"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VersionedStackManager = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const cdk = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const lambda = require("aws-cdk-lib/aws-lambda");
const lambdanodejs = require("aws-cdk-lib/aws-lambda-nodejs");
const cr = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const types_1 = require("./types");
/**
 * This construct will create a custom resource that will manage the versioned stacks,
 * and if too many stacks are present, it will delete the oldest.
 *
 * This prevents inadvertent AWS Limit errors, and keeps your account clean.
 *
 * @param props IVersionedStackManagerProps
 */
class VersionedStackManager extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.id = id;
        this.props = props;
        this.validateProps();
        this.provider = this.createProductionPromoterProvider();
        this.createResource();
    }
    validateProps() {
        return (0, types_1.validateProps)(this.props);
    }
    createProductionPromoterProvider() {
        const providerFileName = "provider";
        const providerPathTs = path.join(__dirname, `${providerFileName}.ts`);
        const providerPathJs = path.join(__dirname, `${providerFileName}.js`);
        const onEventHandler = new lambdanodejs.NodejsFunction(this, `${this.id}-OnEventHandler`, {
            entry: fs.existsSync(providerPathTs)
                ? providerPathTs
                : providerPathJs,
            handler: "onEvent",
            runtime: lambda.Runtime.NODEJS_18_X,
            timeout: cdk.Duration.minutes(5),
        });
        onEventHandler.addToRolePolicy(new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            resources: [
                `arn:aws:cloudformation:${cdk.Stack.of(this).region}:${cdk.Stack.of(this).account}:stack/${this.props.stackNamePrefix}*`,
            ],
            actions: ["cloudformation:DeleteStack"],
        }));
        onEventHandler.addToRolePolicy(new iam.PolicyStatement({
            effect: iam.Effect.ALLOW,
            resources: ["*"],
            actions: ["cloudformation:ListStacks"],
        }));
        return new cr.Provider(this, `${this.id}-VersionedStackManagerProvider`, {
            onEventHandler,
        });
    }
    createResource() {
        return new cdk.CustomResource(this, `${this.id}-VersionedStackManagerResource`, {
            serviceToken: this.provider.serviceToken,
            resourceType: "Custom::VersionedStackManager",
            properties: this.props,
        });
    }
}
_a = JSII_RTTI_SYMBOL_1;
VersionedStackManager[_a] = { fqn: "cdk-versioned-stack-manager.VersionedStackManager", version: "1.0.2" };
exports.VersionedStackManager = VersionedStackManager;
__exportStar(require("./types"), exports);
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQUFBLHlCQUF5QjtBQUN6Qiw2QkFBNkI7QUFFN0IsbUNBQW1DO0FBQ25DLDJDQUEyQztBQUMzQyxpREFBaUQ7QUFDakQsOERBQThEO0FBRTlELG1EQUFtRDtBQUNuRCwyQ0FBdUM7QUFDdkMsbUNBQXFFO0FBRXJFOzs7Ozs7O0dBT0c7QUFDSCxNQUFhLHFCQUFzQixTQUFRLHNCQUFTO0lBR2hELFlBQ0ksS0FBZ0IsRUFDQyxFQUFVLEVBQ1YsS0FBa0M7UUFFbkQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUhBLE9BQUUsR0FBRixFQUFFLENBQVE7UUFDVixVQUFLLEdBQUwsS0FBSyxDQUE2QjtRQUluRCxJQUFJLENBQUMsYUFBYSxFQUFFLENBQUM7UUFFckIsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsZ0NBQWdDLEVBQUUsQ0FBQztRQUN4RCxJQUFJLENBQUMsY0FBYyxFQUFFLENBQUM7SUFDMUIsQ0FBQztJQUVPLGFBQWE7UUFDakIsT0FBTyxJQUFBLHFCQUFhLEVBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ3JDLENBQUM7SUFFTyxnQ0FBZ0M7UUFDcEMsTUFBTSxnQkFBZ0IsR0FBRyxVQUFVLENBQUM7UUFDcEMsTUFBTSxjQUFjLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsR0FBRyxnQkFBZ0IsS0FBSyxDQUFDLENBQUM7UUFDdEUsTUFBTSxjQUFjLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsR0FBRyxnQkFBZ0IsS0FBSyxDQUFDLENBQUM7UUFFdEUsTUFBTSxjQUFjLEdBQUcsSUFBSSxZQUFZLENBQUMsY0FBYyxDQUNsRCxJQUFJLEVBQ0osR0FBRyxJQUFJLENBQUMsRUFBRSxpQkFBaUIsRUFDM0I7WUFDSSxLQUFLLEVBQUUsRUFBRSxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUM7Z0JBQ2hDLENBQUMsQ0FBQyxjQUFjO2dCQUNoQixDQUFDLENBQUMsY0FBYztZQUNwQixPQUFPLEVBQUUsU0FBUztZQUNsQixPQUFPLEVBQUUsTUFBTSxDQUFDLE9BQU8sQ0FBQyxXQUFXO1lBQ25DLE9BQU8sRUFBRSxHQUFHLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7U0FDbkMsQ0FDSixDQUFDO1FBRUYsY0FBYyxDQUFDLGVBQWUsQ0FDMUIsSUFBSSxHQUFHLENBQUMsZUFBZSxDQUFDO1lBQ3BCLE1BQU0sRUFBRSxHQUFHLENBQUMsTUFBTSxDQUFDLEtBQUs7WUFDeEIsU0FBUyxFQUFFO2dCQUNQLDBCQUEwQixHQUFHLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxNQUFNLElBQy9DLEdBQUcsQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLE9BQ3ZCLFVBQVUsSUFBSSxDQUFDLEtBQUssQ0FBQyxlQUFlLEdBQUc7YUFDMUM7WUFDRCxPQUFPLEVBQUUsQ0FBQyw0QkFBNEIsQ0FBQztTQUMxQyxDQUFDLENBQ0wsQ0FBQztRQUVGLGNBQWMsQ0FBQyxlQUFlLENBQzFCLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQztZQUNwQixNQUFNLEVBQUUsR0FBRyxDQUFDLE1BQU0sQ0FBQyxLQUFLO1lBQ3hCLFNBQVMsRUFBRSxDQUFDLEdBQUcsQ0FBQztZQUNoQixPQUFPLEVBQUUsQ0FBQywyQkFBMkIsQ0FBQztTQUN6QyxDQUFDLENBQ0wsQ0FBQztRQUVGLE9BQU8sSUFBSSxFQUFFLENBQUMsUUFBUSxDQUNsQixJQUFJLEVBQ0osR0FBRyxJQUFJLENBQUMsRUFBRSxnQ0FBZ0MsRUFDMUM7WUFDSSxjQUFjO1NBQ2pCLENBQ0osQ0FBQztJQUNOLENBQUM7SUFFTyxjQUFjO1FBQ2xCLE9BQU8sSUFBSSxHQUFHLENBQUMsY0FBYyxDQUN6QixJQUFJLEVBQ0osR0FBRyxJQUFJLENBQUMsRUFBRSxnQ0FBZ0MsRUFDMUM7WUFDSSxZQUFZLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxZQUFZO1lBQ3hDLFlBQVksRUFBRSwrQkFBK0I7WUFDN0MsVUFBVSxFQUFFLElBQUksQ0FBQyxLQUFLO1NBQ3pCLENBQ0osQ0FBQztJQUNOLENBQUM7Ozs7QUE3RVEsc0RBQXFCO0FBZ0ZsQywwQ0FBd0IiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBmcyBmcm9tIFwiZnNcIjtcbmltcG9ydCAqIGFzIHBhdGggZnJvbSBcInBhdGhcIjtcblxuaW1wb3J0ICogYXMgY2RrIGZyb20gXCJhd3MtY2RrLWxpYlwiO1xuaW1wb3J0ICogYXMgaWFtIGZyb20gXCJhd3MtY2RrLWxpYi9hd3MtaWFtXCI7XG5pbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSBcImF3cy1jZGstbGliL2F3cy1sYW1iZGFcIjtcbmltcG9ydCAqIGFzIGxhbWJkYW5vZGVqcyBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWxhbWJkYS1ub2RlanNcIjtcblxuaW1wb3J0ICogYXMgY3IgZnJvbSBcImF3cy1jZGstbGliL2N1c3RvbS1yZXNvdXJjZXNcIjtcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5pbXBvcnQgeyBJVmVyc2lvbmVkU3RhY2tNYW5hZ2VyUHJvcHMsIHZhbGlkYXRlUHJvcHMgfSBmcm9tIFwiLi90eXBlc1wiO1xuXG4vKipcbiAqIFRoaXMgY29uc3RydWN0IHdpbGwgY3JlYXRlIGEgY3VzdG9tIHJlc291cmNlIHRoYXQgd2lsbCBtYW5hZ2UgdGhlIHZlcnNpb25lZCBzdGFja3MsXG4gKiBhbmQgaWYgdG9vIG1hbnkgc3RhY2tzIGFyZSBwcmVzZW50LCBpdCB3aWxsIGRlbGV0ZSB0aGUgb2xkZXN0LlxuICpcbiAqIFRoaXMgcHJldmVudHMgaW5hZHZlcnRlbnQgQVdTIExpbWl0IGVycm9ycywgYW5kIGtlZXBzIHlvdXIgYWNjb3VudCBjbGVhbi5cbiAqXG4gKiBAcGFyYW0gcHJvcHMgSVZlcnNpb25lZFN0YWNrTWFuYWdlclByb3BzXG4gKi9cbmV4cG9ydCBjbGFzcyBWZXJzaW9uZWRTdGFja01hbmFnZXIgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICAgIHByaXZhdGUgcmVhZG9ubHkgcHJvdmlkZXI6IGNyLlByb3ZpZGVyO1xuXG4gICAgY29uc3RydWN0b3IoXG4gICAgICAgIHNjb3BlOiBDb25zdHJ1Y3QsXG4gICAgICAgIHByaXZhdGUgcmVhZG9ubHkgaWQ6IHN0cmluZyxcbiAgICAgICAgcHJpdmF0ZSByZWFkb25seSBwcm9wczogSVZlcnNpb25lZFN0YWNrTWFuYWdlclByb3BzLFxuICAgICkge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgICAgIHRoaXMudmFsaWRhdGVQcm9wcygpO1xuXG4gICAgICAgIHRoaXMucHJvdmlkZXIgPSB0aGlzLmNyZWF0ZVByb2R1Y3Rpb25Qcm9tb3RlclByb3ZpZGVyKCk7XG4gICAgICAgIHRoaXMuY3JlYXRlUmVzb3VyY2UoKTtcbiAgICB9XG5cbiAgICBwcml2YXRlIHZhbGlkYXRlUHJvcHMoKTogYm9vbGVhbiB7XG4gICAgICAgIHJldHVybiB2YWxpZGF0ZVByb3BzKHRoaXMucHJvcHMpO1xuICAgIH1cblxuICAgIHByaXZhdGUgY3JlYXRlUHJvZHVjdGlvblByb21vdGVyUHJvdmlkZXIoKTogY3IuUHJvdmlkZXIge1xuICAgICAgICBjb25zdCBwcm92aWRlckZpbGVOYW1lID0gXCJwcm92aWRlclwiO1xuICAgICAgICBjb25zdCBwcm92aWRlclBhdGhUcyA9IHBhdGguam9pbihfX2Rpcm5hbWUsIGAke3Byb3ZpZGVyRmlsZU5hbWV9LnRzYCk7XG4gICAgICAgIGNvbnN0IHByb3ZpZGVyUGF0aEpzID0gcGF0aC5qb2luKF9fZGlybmFtZSwgYCR7cHJvdmlkZXJGaWxlTmFtZX0uanNgKTtcblxuICAgICAgICBjb25zdCBvbkV2ZW50SGFuZGxlciA9IG5ldyBsYW1iZGFub2RlanMuTm9kZWpzRnVuY3Rpb24oXG4gICAgICAgICAgICB0aGlzLFxuICAgICAgICAgICAgYCR7dGhpcy5pZH0tT25FdmVudEhhbmRsZXJgLFxuICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgIGVudHJ5OiBmcy5leGlzdHNTeW5jKHByb3ZpZGVyUGF0aFRzKVxuICAgICAgICAgICAgICAgICAgICA/IHByb3ZpZGVyUGF0aFRzXG4gICAgICAgICAgICAgICAgICAgIDogcHJvdmlkZXJQYXRoSnMsXG4gICAgICAgICAgICAgICAgaGFuZGxlcjogXCJvbkV2ZW50XCIsXG4gICAgICAgICAgICAgICAgcnVudGltZTogbGFtYmRhLlJ1bnRpbWUuTk9ERUpTXzE4X1gsXG4gICAgICAgICAgICAgICAgdGltZW91dDogY2RrLkR1cmF0aW9uLm1pbnV0ZXMoNSksXG4gICAgICAgICAgICB9LFxuICAgICAgICApO1xuXG4gICAgICAgIG9uRXZlbnRIYW5kbGVyLmFkZFRvUm9sZVBvbGljeShcbiAgICAgICAgICAgIG5ldyBpYW0uUG9saWN5U3RhdGVtZW50KHtcbiAgICAgICAgICAgICAgICBlZmZlY3Q6IGlhbS5FZmZlY3QuQUxMT1csXG4gICAgICAgICAgICAgICAgcmVzb3VyY2VzOiBbXG4gICAgICAgICAgICAgICAgICAgIGBhcm46YXdzOmNsb3VkZm9ybWF0aW9uOiR7Y2RrLlN0YWNrLm9mKHRoaXMpLnJlZ2lvbn06JHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGNkay5TdGFjay5vZih0aGlzKS5hY2NvdW50XG4gICAgICAgICAgICAgICAgICAgIH06c3RhY2svJHt0aGlzLnByb3BzLnN0YWNrTmFtZVByZWZpeH0qYCxcbiAgICAgICAgICAgICAgICBdLFxuICAgICAgICAgICAgICAgIGFjdGlvbnM6IFtcImNsb3VkZm9ybWF0aW9uOkRlbGV0ZVN0YWNrXCJdLFxuICAgICAgICAgICAgfSksXG4gICAgICAgICk7XG5cbiAgICAgICAgb25FdmVudEhhbmRsZXIuYWRkVG9Sb2xlUG9saWN5KFxuICAgICAgICAgICAgbmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgICAgICAgICAgIGVmZmVjdDogaWFtLkVmZmVjdC5BTExPVyxcbiAgICAgICAgICAgICAgICByZXNvdXJjZXM6IFtcIipcIl0sXG4gICAgICAgICAgICAgICAgYWN0aW9uczogW1wiY2xvdWRmb3JtYXRpb246TGlzdFN0YWNrc1wiXSxcbiAgICAgICAgICAgIH0pLFxuICAgICAgICApO1xuXG4gICAgICAgIHJldHVybiBuZXcgY3IuUHJvdmlkZXIoXG4gICAgICAgICAgICB0aGlzLFxuICAgICAgICAgICAgYCR7dGhpcy5pZH0tVmVyc2lvbmVkU3RhY2tNYW5hZ2VyUHJvdmlkZXJgLFxuICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgIG9uRXZlbnRIYW5kbGVyLFxuICAgICAgICAgICAgfSxcbiAgICAgICAgKTtcbiAgICB9XG5cbiAgICBwcml2YXRlIGNyZWF0ZVJlc291cmNlKCk6IGNkay5DdXN0b21SZXNvdXJjZSB7XG4gICAgICAgIHJldHVybiBuZXcgY2RrLkN1c3RvbVJlc291cmNlKFxuICAgICAgICAgICAgdGhpcyxcbiAgICAgICAgICAgIGAke3RoaXMuaWR9LVZlcnNpb25lZFN0YWNrTWFuYWdlclJlc291cmNlYCxcbiAgICAgICAgICAgIHtcbiAgICAgICAgICAgICAgICBzZXJ2aWNlVG9rZW46IHRoaXMucHJvdmlkZXIuc2VydmljZVRva2VuLFxuICAgICAgICAgICAgICAgIHJlc291cmNlVHlwZTogXCJDdXN0b206OlZlcnNpb25lZFN0YWNrTWFuYWdlclwiLFxuICAgICAgICAgICAgICAgIHByb3BlcnRpZXM6IHRoaXMucHJvcHMsXG4gICAgICAgICAgICB9LFxuICAgICAgICApO1xuICAgIH1cbn1cblxuZXhwb3J0ICogZnJvbSBcIi4vdHlwZXNcIjtcbiJdfQ==