"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateProps = void 0;
const validateProps = (props) => {
    if (props.numberOfStacksToKeep < 1) {
        throw new Error("numberOfStacksToKeep must be greater than or equal to 1");
    }
    if (!props.requestId) {
        throw new Error("requestId must be provided");
    }
    if (!props.stackNamePrefix) {
        throw new Error("stackNamePrefix must be provided");
    }
    if (!!props.sortDirection &&
        props.sortDirection !== "ASCENDING" &&
        props.sortDirection !== "DESCENDING") {
        throw new Error("sortDirection must be either ASCENDING or DESCENDING");
    }
    return true;
};
exports.validateProps = validateProps;
//# sourceMappingURL=data:application/json;base64,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