"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultIdentityProviderConfig = void 0;
class DefaultIdentityProviderConfig {
    constructor(config) {
        this.authSchemes = new Map();
        for (const [key, value] of Object.entries(config)) {
            if (value !== undefined) {
                this.authSchemes.set(key, value);
            }
        }
    }
    getIdentityProvider(schemeId) {
        return this.authSchemes.get(schemeId);
    }
}
exports.DefaultIdentityProviderConfig = DefaultIdentityProviderConfig;
