"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AWSSDKSigV4Signer = void 0;
const protocol_http_1 = require("@smithy/protocol-http");
const utils_1 = require("../utils");
const throwAWSSDKSigningPropertyError_1 = require("./throwAWSSDKSigningPropertyError");
const validateSigningProperties = async (signingProperties) => {
    var _a, _b, _c;
    const context = (0, throwAWSSDKSigningPropertyError_1.throwAWSSDKSigningPropertyError)("context", signingProperties.context);
    const config = (0, throwAWSSDKSigningPropertyError_1.throwAWSSDKSigningPropertyError)("config", signingProperties.config);
    const authScheme = (_c = (_b = (_a = context.endpointV2) === null || _a === void 0 ? void 0 : _a.properties) === null || _b === void 0 ? void 0 : _b.authSchemes) === null || _c === void 0 ? void 0 : _c[0];
    const signerFunction = (0, throwAWSSDKSigningPropertyError_1.throwAWSSDKSigningPropertyError)("signer", config.signer);
    const signer = await signerFunction(authScheme);
    const signingRegion = signingProperties === null || signingProperties === void 0 ? void 0 : signingProperties.signingRegion;
    const signingName = signingProperties === null || signingProperties === void 0 ? void 0 : signingProperties.signingName;
    return {
        config,
        signer,
        signingRegion,
        signingName,
    };
};
class AWSSDKSigV4Signer {
    async sign(httpRequest, identity, signingProperties) {
        if (!protocol_http_1.HttpRequest.isInstance(httpRequest)) {
            throw new Error("The request is not an instance of `HttpRequest` and cannot be signed");
        }
        const { config, signer, signingRegion, signingName } = await validateSigningProperties(signingProperties);
        const signedRequest = await signer.sign(httpRequest, {
            signingDate: (0, utils_1.getSkewCorrectedDate)(config.systemClockOffset),
            signingRegion: signingRegion,
            signingService: signingName,
        });
        return signedRequest;
    }
    errorHandler(signingProperties) {
        return (error) => {
            var _a;
            const serverTime = (_a = error.ServerTime) !== null && _a !== void 0 ? _a : (0, utils_1.getDateHeader)(error.$response);
            if (serverTime) {
                const config = (0, throwAWSSDKSigningPropertyError_1.throwAWSSDKSigningPropertyError)("config", signingProperties.config);
                config.systemClockOffset = (0, utils_1.getUpdatedSystemClockOffset)(serverTime, config.systemClockOffset);
            }
            throw error;
        };
    }
    successHandler(httpResponse, signingProperties) {
        const dateHeader = (0, utils_1.getDateHeader)(httpResponse);
        if (dateHeader) {
            const config = (0, throwAWSSDKSigningPropertyError_1.throwAWSSDKSigningPropertyError)("config", signingProperties.config);
            config.systemClockOffset = (0, utils_1.getUpdatedSystemClockOffset)(dateHeader, config.systemClockOffset);
        }
    }
}
exports.AWSSDKSigV4Signer = AWSSDKSigV4Signer;
