"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpBearerAuthSigner = void 0;
class HttpBearerAuthSigner {
    async sign(httpRequest, identity, signingProperties) {
        const clonedRequest = httpRequest.clone();
        if (!identity.token) {
            throw new Error("request could not be signed with `token` since the `token` is not defined");
        }
        clonedRequest.headers["Authorization"] = `Bearer ${identity.token}`;
        return clonedRequest;
    }
}
exports.HttpBearerAuthSigner = HttpBearerAuthSigner;
