"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitUntilChangeSetCreateComplete = exports.waitForChangeSetCreateComplete = void 0;
const util_waiter_1 = require("@smithy/util-waiter");
const DescribeChangeSetCommand_1 = require("../commands/DescribeChangeSetCommand");
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new DescribeChangeSetCommand_1.DescribeChangeSetCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                return result.Status;
            };
            if (returnComparator() === "CREATE_COMPLETE") {
                return { state: util_waiter_1.WaiterState.SUCCESS, reason };
            }
        }
        catch (e) { }
        try {
            const returnComparator = () => {
                return result.Status;
            };
            if (returnComparator() === "FAILED") {
                return { state: util_waiter_1.WaiterState.FAILURE, reason };
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "ValidationError") {
            return { state: util_waiter_1.WaiterState.FAILURE, reason };
        }
    }
    return { state: util_waiter_1.WaiterState.RETRY, reason };
};
const waitForChangeSetCreateComplete = async (params, input) => {
    const serviceDefaults = { minDelay: 30, maxDelay: 120 };
    return (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
};
exports.waitForChangeSetCreateComplete = waitForChangeSetCreateComplete;
const waitUntilChangeSetCreateComplete = async (params, input) => {
    const serviceDefaults = { minDelay: 30, maxDelay: 120 };
    const result = await (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
    return (0, util_waiter_1.checkExceptions)(result);
};
exports.waitUntilChangeSetCreateComplete = waitUntilChangeSetCreateComplete;
