"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitUntilStackExists = exports.waitForStackExists = void 0;
const util_waiter_1 = require("@smithy/util-waiter");
const DescribeStacksCommand_1 = require("../commands/DescribeStacksCommand");
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new DescribeStacksCommand_1.DescribeStacksCommand(input));
        reason = result;
        return { state: util_waiter_1.WaiterState.SUCCESS, reason };
    }
    catch (exception) {
        reason = exception;
        if (exception.name && exception.name == "ValidationError") {
            return { state: util_waiter_1.WaiterState.RETRY, reason };
        }
    }
    return { state: util_waiter_1.WaiterState.RETRY, reason };
};
const waitForStackExists = async (params, input) => {
    const serviceDefaults = { minDelay: 5, maxDelay: 120 };
    return (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
};
exports.waitForStackExists = waitForStackExists;
const waitUntilStackExists = async (params, input) => {
    const serviceDefaults = { minDelay: 5, maxDelay: 120 };
    const result = await (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
    return (0, util_waiter_1.checkExceptions)(result);
};
exports.waitUntilStackExists = waitUntilStackExists;
