"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.waitUntilTypeRegistrationComplete = exports.waitForTypeRegistrationComplete = void 0;
const util_waiter_1 = require("@smithy/util-waiter");
const DescribeTypeRegistrationCommand_1 = require("../commands/DescribeTypeRegistrationCommand");
const checkState = async (client, input) => {
    let reason;
    try {
        const result = await client.send(new DescribeTypeRegistrationCommand_1.DescribeTypeRegistrationCommand(input));
        reason = result;
        try {
            const returnComparator = () => {
                return result.ProgressStatus;
            };
            if (returnComparator() === "COMPLETE") {
                return { state: util_waiter_1.WaiterState.SUCCESS, reason };
            }
        }
        catch (e) { }
        try {
            const returnComparator = () => {
                return result.ProgressStatus;
            };
            if (returnComparator() === "FAILED") {
                return { state: util_waiter_1.WaiterState.FAILURE, reason };
            }
        }
        catch (e) { }
    }
    catch (exception) {
        reason = exception;
    }
    return { state: util_waiter_1.WaiterState.RETRY, reason };
};
const waitForTypeRegistrationComplete = async (params, input) => {
    const serviceDefaults = { minDelay: 30, maxDelay: 120 };
    return (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
};
exports.waitForTypeRegistrationComplete = waitForTypeRegistrationComplete;
const waitUntilTypeRegistrationComplete = async (params, input) => {
    const serviceDefaults = { minDelay: 30, maxDelay: 120 };
    const result = await (0, util_waiter_1.createWaiter)({ ...serviceDefaults, ...params }, input, checkState);
    return (0, util_waiter_1.checkExceptions)(result);
};
exports.waitUntilTypeRegistrationComplete = waitUntilTypeRegistrationComplete;
