import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_RecordHandlerProgressCommand, se_RecordHandlerProgressCommand } from "../protocols/Aws_query";
export { $Command };
export class RecordHandlerProgressCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
})
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CloudFormation", "RecordHandlerProgress", {})
    .n("CloudFormationClient", "RecordHandlerProgressCommand")
    .f(void 0, void 0)
    .ser(se_RecordHandlerProgressCommand)
    .de(de_RecordHandlerProgressCommand)
    .build() {
}
