import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFormationClient";
import { ActivateOrganizationsAccessInput, ActivateOrganizationsAccessOutput } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link ActivateOrganizationsAccessCommand}.
 */
export interface ActivateOrganizationsAccessCommandInput extends ActivateOrganizationsAccessInput {
}
/**
 * @public
 *
 * The output of {@link ActivateOrganizationsAccessCommand}.
 */
export interface ActivateOrganizationsAccessCommandOutput extends ActivateOrganizationsAccessOutput, __MetadataBearer {
}
declare const ActivateOrganizationsAccessCommand_base: {
    new (input: ActivateOrganizationsAccessCommandInput): import("@smithy/smithy-client").CommandImpl<ActivateOrganizationsAccessCommandInput, ActivateOrganizationsAccessCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * @public
 * <p>Activate trusted access with Organizations. With trusted access between StackSets
 *       and Organizations activated, the management account has permissions to create
 *       and manage StackSets for your organization.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFormationClient, ActivateOrganizationsAccessCommand } from "@aws-sdk/client-cloudformation"; // ES Modules import
 * // const { CloudFormationClient, ActivateOrganizationsAccessCommand } = require("@aws-sdk/client-cloudformation"); // CommonJS import
 * const client = new CloudFormationClient(config);
 * const input = {};
 * const command = new ActivateOrganizationsAccessCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param ActivateOrganizationsAccessCommandInput - {@link ActivateOrganizationsAccessCommandInput}
 * @returns {@link ActivateOrganizationsAccessCommandOutput}
 * @see {@link ActivateOrganizationsAccessCommandInput} for command's `input` shape.
 * @see {@link ActivateOrganizationsAccessCommandOutput} for command's `response` shape.
 * @see {@link CloudFormationClientResolvedConfig | config} for CloudFormationClient's `config` shape.
 *
 * @throws {@link InvalidOperationException} (client fault)
 *  <p>The specified operation isn't valid.</p>
 *
 * @throws {@link OperationNotFoundException} (client fault)
 *  <p>The specified ID refers to an operation that doesn't exist.</p>
 *
 * @throws {@link CloudFormationServiceException}
 * <p>Base exception class for all service exceptions from CloudFormation service.</p>
 *
 */
export declare class ActivateOrganizationsAccessCommand extends ActivateOrganizationsAccessCommand_base {
}
