import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFormationClient";
import { GetStackPolicyInput, GetStackPolicyOutput } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link GetStackPolicyCommand}.
 */
export interface GetStackPolicyCommandInput extends GetStackPolicyInput {
}
/**
 * @public
 *
 * The output of {@link GetStackPolicyCommand}.
 */
export interface GetStackPolicyCommandOutput extends GetStackPolicyOutput, __MetadataBearer {
}
declare const GetStackPolicyCommand_base: {
    new (input: GetStackPolicyCommandInput): import("@smithy/smithy-client").CommandImpl<GetStackPolicyCommandInput, GetStackPolicyCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * @public
 * <p>Returns the stack policy for a specified stack. If a stack doesn't have a policy, a null value is
 *    returned.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFormationClient, GetStackPolicyCommand } from "@aws-sdk/client-cloudformation"; // ES Modules import
 * // const { CloudFormationClient, GetStackPolicyCommand } = require("@aws-sdk/client-cloudformation"); // CommonJS import
 * const client = new CloudFormationClient(config);
 * const input = { // GetStackPolicyInput
 *   StackName: "STRING_VALUE", // required
 * };
 * const command = new GetStackPolicyCommand(input);
 * const response = await client.send(command);
 * // { // GetStackPolicyOutput
 * //   StackPolicyBody: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param GetStackPolicyCommandInput - {@link GetStackPolicyCommandInput}
 * @returns {@link GetStackPolicyCommandOutput}
 * @see {@link GetStackPolicyCommandInput} for command's `input` shape.
 * @see {@link GetStackPolicyCommandOutput} for command's `response` shape.
 * @see {@link CloudFormationClientResolvedConfig | config} for CloudFormationClient's `config` shape.
 *
 * @throws {@link CloudFormationServiceException}
 * <p>Base exception class for all service exceptions from CloudFormation service.</p>
 *
 */
export declare class GetStackPolicyCommand extends GetStackPolicyCommand_base {
}
