import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFormationClient";
import { ListStackSetsInput, ListStackSetsOutput } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link ListStackSetsCommand}.
 */
export interface ListStackSetsCommandInput extends ListStackSetsInput {
}
/**
 * @public
 *
 * The output of {@link ListStackSetsCommand}.
 */
export interface ListStackSetsCommandOutput extends ListStackSetsOutput, __MetadataBearer {
}
declare const ListStackSetsCommand_base: {
    new (input: ListStackSetsCommandInput): import("@smithy/smithy-client").CommandImpl<ListStackSetsCommandInput, ListStackSetsCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * @public
 * <p>Returns summary information about stack sets that are associated with the user.</p>
 *          <ul>
 *             <li>
 *                <p>[Self-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed in
 *      to your Amazon Web Services account, <code>ListStackSets</code> returns all self-managed stack sets in your Amazon Web Services account.</p>
 *             </li>
 *             <li>
 *                <p>[Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>SELF</code> while signed
 *      in to the organization's management account, <code>ListStackSets</code> returns all stack sets in the
 *      management account.</p>
 *             </li>
 *             <li>
 *                <p>[Service-managed permissions] If you set the <code>CallAs</code> parameter to <code>DELEGATED_ADMIN</code>
 *      while signed in to your member account, <code>ListStackSets</code> returns all stack sets with service-managed
 *      permissions in the management account.</p>
 *             </li>
 *          </ul>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFormationClient, ListStackSetsCommand } from "@aws-sdk/client-cloudformation"; // ES Modules import
 * // const { CloudFormationClient, ListStackSetsCommand } = require("@aws-sdk/client-cloudformation"); // CommonJS import
 * const client = new CloudFormationClient(config);
 * const input = { // ListStackSetsInput
 *   NextToken: "STRING_VALUE",
 *   MaxResults: Number("int"),
 *   Status: "ACTIVE" || "DELETED",
 *   CallAs: "SELF" || "DELEGATED_ADMIN",
 * };
 * const command = new ListStackSetsCommand(input);
 * const response = await client.send(command);
 * // { // ListStackSetsOutput
 * //   Summaries: [ // StackSetSummaries
 * //     { // StackSetSummary
 * //       StackSetName: "STRING_VALUE",
 * //       StackSetId: "STRING_VALUE",
 * //       Description: "STRING_VALUE",
 * //       Status: "ACTIVE" || "DELETED",
 * //       AutoDeployment: { // AutoDeployment
 * //         Enabled: true || false,
 * //         RetainStacksOnAccountRemoval: true || false,
 * //       },
 * //       PermissionModel: "SERVICE_MANAGED" || "SELF_MANAGED",
 * //       DriftStatus: "DRIFTED" || "IN_SYNC" || "UNKNOWN" || "NOT_CHECKED",
 * //       LastDriftCheckTimestamp: new Date("TIMESTAMP"),
 * //       ManagedExecution: { // ManagedExecution
 * //         Active: true || false,
 * //       },
 * //     },
 * //   ],
 * //   NextToken: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param ListStackSetsCommandInput - {@link ListStackSetsCommandInput}
 * @returns {@link ListStackSetsCommandOutput}
 * @see {@link ListStackSetsCommandInput} for command's `input` shape.
 * @see {@link ListStackSetsCommandOutput} for command's `response` shape.
 * @see {@link CloudFormationClientResolvedConfig | config} for CloudFormationClient's `config` shape.
 *
 * @throws {@link CloudFormationServiceException}
 * <p>Base exception class for all service exceptions from CloudFormation service.</p>
 *
 */
export declare class ListStackSetsCommand extends ListStackSetsCommand_base {
}
