import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFormationClient";
import { TestTypeInput, TestTypeOutput } from "../models/models_0";
/**
 * @public
 */
export { __MetadataBearer, $Command };
/**
 * @public
 *
 * The input for {@link TestTypeCommand}.
 */
export interface TestTypeCommandInput extends TestTypeInput {
}
/**
 * @public
 *
 * The output of {@link TestTypeCommand}.
 */
export interface TestTypeCommandOutput extends TestTypeOutput, __MetadataBearer {
}
declare const TestTypeCommand_base: {
    new (input: TestTypeCommandInput): import("@smithy/smithy-client").CommandImpl<TestTypeCommandInput, TestTypeCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * @public
 * <p>Tests a registered extension to make sure it meets all necessary requirements for being published in the CloudFormation registry.</p>
 *          <ul>
 *             <li>
 *                <p>For resource types, this includes passing all contracts tests defined for the type.</p>
 *             </li>
 *             <li>
 *                <p>For modules, this includes determining if the module's model meets all necessary requirements.</p>
 *             </li>
 *          </ul>
 *          <p>For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-testing">Testing your public
 *     extension prior to publishing</a> in the <i>CloudFormation CLI User Guide</i>.</p>
 *          <p>If you don't specify a version, CloudFormation uses the default version of the extension in your
 *    account and Region for testing.</p>
 *          <p>To perform testing, CloudFormation assumes the execution role specified when the type was registered.
 *    For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html">RegisterType</a>.</p>
 *          <p>Once you've initiated testing on an extension using <code>TestType</code>, you can pass the returned
 *     <code>TypeVersionArn</code> into <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html">DescribeType</a> to monitor the current test
 *    status and test status description for the extension.</p>
 *          <p>An extension must have a test status of <code>PASSED</code> before it can be published. For more information,
 *    see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-publish.html">Publishing
 *     extensions to make them available for public use</a> in the <i>CloudFormation CLI User
 *     Guide</i>.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFormationClient, TestTypeCommand } from "@aws-sdk/client-cloudformation"; // ES Modules import
 * // const { CloudFormationClient, TestTypeCommand } = require("@aws-sdk/client-cloudformation"); // CommonJS import
 * const client = new CloudFormationClient(config);
 * const input = { // TestTypeInput
 *   Arn: "STRING_VALUE",
 *   Type: "RESOURCE" || "MODULE" || "HOOK",
 *   TypeName: "STRING_VALUE",
 *   VersionId: "STRING_VALUE",
 *   LogDeliveryBucket: "STRING_VALUE",
 * };
 * const command = new TestTypeCommand(input);
 * const response = await client.send(command);
 * // { // TestTypeOutput
 * //   TypeVersionArn: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param TestTypeCommandInput - {@link TestTypeCommandInput}
 * @returns {@link TestTypeCommandOutput}
 * @see {@link TestTypeCommandInput} for command's `input` shape.
 * @see {@link TestTypeCommandOutput} for command's `response` shape.
 * @see {@link CloudFormationClientResolvedConfig | config} for CloudFormationClient's `config` shape.
 *
 * @throws {@link CFNRegistryException} (client fault)
 *  <p>An error occurred during a CloudFormation registry operation.</p>
 *
 * @throws {@link TypeNotFoundException} (client fault)
 *  <p>The specified extension doesn't exist in the CloudFormation registry.</p>
 *
 * @throws {@link CloudFormationServiceException}
 * <p>Base exception class for all service exceptions from CloudFormation service.</p>
 *
 */
export declare class TestTypeCommand extends TestTypeCommand_base {
}
