# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from .core.api_error import ApiError
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .core.pagination import AsyncPager, BaseHttpResponse, SyncPager
from .core.pydantic_utilities import parse_obj_as
from .core.request_options import RequestOptions
from .errors.bad_request_error import BadRequestError
from .errors.unauthorized_error import UnauthorizedError
from .types.list_meetings_request_meeting_type import ListMeetingsRequestMeetingType
from .types.meeting import Meeting
from .types.meeting_list_response import MeetingListResponse
from .types.team import Team
from .types.team_list_response import TeamListResponse
from .types.team_member import TeamMember
from .types.team_member_list_response import TeamMemberListResponse


class RawBaseClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_meetings(
        self,
        *,
        recorded_by: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        teams: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        calendar_invitees: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        created_after: typing.Optional[str] = None,
        meeting_type: typing.Optional[ListMeetingsRequestMeetingType] = None,
        include_transcript: typing.Optional[bool] = None,
        cursor: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Meeting]:
        """
        Parameters
        ----------
        recorded_by : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Email addresses of meeting owners.

            Pass the parameter once per value, e.g.
            `recorded_by[]=ceo@acme.com&recorded_by[]=pm@acme.com`.

            Returns meetings hosted by any of the specified users.

        teams : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Team names to filter by.

            Pass the parameter once per value, e.g.
            `teams[]=Sales&teams[]=Engineering`.

            Returns meetings that belong to any of the specified teams.

        calendar_invitees : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Email addresses of calendar_invitees.

            Pass the parameter once per value, e.g.
            `calendar_invitees[]=cfo@acme.com&calendar_invitees[]=legal@acme.com`.

            Returns meetings where any of the given email addresses appear
            in the calendar_invitees list.

        created_after : typing.Optional[str]
            Filter to meetings with created_at after this timestamp, e.g. `created_after=2025-01-01T00:00:00Z`.

        meeting_type : typing.Optional[ListMeetingsRequestMeetingType]
            Filter by meeting type.

        include_transcript : typing.Optional[bool]
            Include the transcript for each meeting.

        cursor : typing.Optional[str]
            Cursor for pagination.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Meeting]
            Paginated list of meetings.
        """
        _response = self._client_wrapper.httpx_client.request(
            "meetings",
            method="GET",
            params={
                "recorded_by[]": recorded_by,
                "teams[]": teams,
                "calendar_invitees[]": calendar_invitees,
                "created_after": created_after,
                "meeting_type": meeting_type,
                "include_transcript": include_transcript,
                "cursor": cursor,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    MeetingListResponse,
                    parse_obj_as(
                        type_=MeetingListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.items
                _parsed_next = _parsed_response.next_cursor
                _has_next = _parsed_next is not None and _parsed_next != ""
                _get_next = lambda: self.list_meetings(
                    recorded_by=recorded_by,
                    teams=teams,
                    calendar_invitees=calendar_invitees,
                    created_after=created_after,
                    meeting_type=meeting_type,
                    include_transcript=include_transcript,
                    cursor=_parsed_next,
                    request_options=request_options,
                )
                return SyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list_teams(
        self, *, cursor: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> SyncPager[Team]:
        """
        Parameters
        ----------
        cursor : typing.Optional[str]
            Cursor for pagination.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Team]
            Paginated list of teams.
        """
        _response = self._client_wrapper.httpx_client.request(
            "teams",
            method="GET",
            params={
                "cursor": cursor,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    TeamListResponse,
                    parse_obj_as(
                        type_=TeamListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.items
                _parsed_next = _parsed_response.next_cursor
                _has_next = _parsed_next is not None and _parsed_next != ""
                _get_next = lambda: self.list_teams(
                    cursor=_parsed_next,
                    request_options=request_options,
                )
                return SyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list_team_members(
        self,
        *,
        team: typing.Optional[str] = None,
        cursor: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[TeamMember]:
        """
        Parameters
        ----------
        team : typing.Optional[str]
            Team name to filter by.

        cursor : typing.Optional[str]
            Cursor for pagination.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[TeamMember]
            Paginated list of team members.
        """
        _response = self._client_wrapper.httpx_client.request(
            "team_members",
            method="GET",
            params={
                "team": team,
                "cursor": cursor,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    TeamMemberListResponse,
                    parse_obj_as(
                        type_=TeamMemberListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.items
                _parsed_next = _parsed_response.next_cursor
                _has_next = _parsed_next is not None and _parsed_next != ""
                _get_next = lambda: self.list_team_members(
                    team=team,
                    cursor=_parsed_next,
                    request_options=request_options,
                )
                return SyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawBaseClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_meetings(
        self,
        *,
        recorded_by: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        teams: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        calendar_invitees: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        created_after: typing.Optional[str] = None,
        meeting_type: typing.Optional[ListMeetingsRequestMeetingType] = None,
        include_transcript: typing.Optional[bool] = None,
        cursor: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Meeting]:
        """
        Parameters
        ----------
        recorded_by : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Email addresses of meeting owners.

            Pass the parameter once per value, e.g.
            `recorded_by[]=ceo@acme.com&recorded_by[]=pm@acme.com`.

            Returns meetings hosted by any of the specified users.

        teams : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Team names to filter by.

            Pass the parameter once per value, e.g.
            `teams[]=Sales&teams[]=Engineering`.

            Returns meetings that belong to any of the specified teams.

        calendar_invitees : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Email addresses of calendar_invitees.

            Pass the parameter once per value, e.g.
            `calendar_invitees[]=cfo@acme.com&calendar_invitees[]=legal@acme.com`.

            Returns meetings where any of the given email addresses appear
            in the calendar_invitees list.

        created_after : typing.Optional[str]
            Filter to meetings with created_at after this timestamp, e.g. `created_after=2025-01-01T00:00:00Z`.

        meeting_type : typing.Optional[ListMeetingsRequestMeetingType]
            Filter by meeting type.

        include_transcript : typing.Optional[bool]
            Include the transcript for each meeting.

        cursor : typing.Optional[str]
            Cursor for pagination.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Meeting]
            Paginated list of meetings.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "meetings",
            method="GET",
            params={
                "recorded_by[]": recorded_by,
                "teams[]": teams,
                "calendar_invitees[]": calendar_invitees,
                "created_after": created_after,
                "meeting_type": meeting_type,
                "include_transcript": include_transcript,
                "cursor": cursor,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    MeetingListResponse,
                    parse_obj_as(
                        type_=MeetingListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.items
                _parsed_next = _parsed_response.next_cursor
                _has_next = _parsed_next is not None and _parsed_next != ""

                async def _get_next():
                    return await self.list_meetings(
                        recorded_by=recorded_by,
                        teams=teams,
                        calendar_invitees=calendar_invitees,
                        created_after=created_after,
                        meeting_type=meeting_type,
                        include_transcript=include_transcript,
                        cursor=_parsed_next,
                        request_options=request_options,
                    )

                return AsyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list_teams(
        self, *, cursor: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncPager[Team]:
        """
        Parameters
        ----------
        cursor : typing.Optional[str]
            Cursor for pagination.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Team]
            Paginated list of teams.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "teams",
            method="GET",
            params={
                "cursor": cursor,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    TeamListResponse,
                    parse_obj_as(
                        type_=TeamListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.items
                _parsed_next = _parsed_response.next_cursor
                _has_next = _parsed_next is not None and _parsed_next != ""

                async def _get_next():
                    return await self.list_teams(
                        cursor=_parsed_next,
                        request_options=request_options,
                    )

                return AsyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list_team_members(
        self,
        *,
        team: typing.Optional[str] = None,
        cursor: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[TeamMember]:
        """
        Parameters
        ----------
        team : typing.Optional[str]
            Team name to filter by.

        cursor : typing.Optional[str]
            Cursor for pagination.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[TeamMember]
            Paginated list of team members.
        """
        _response = await self._client_wrapper.httpx_client.request(
            "team_members",
            method="GET",
            params={
                "team": team,
                "cursor": cursor,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    TeamMemberListResponse,
                    parse_obj_as(
                        type_=TeamMemberListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.items
                _parsed_next = _parsed_response.next_cursor
                _has_next = _parsed_next is not None and _parsed_next != ""

                async def _get_next():
                    return await self.list_team_members(
                        team=team,
                        cursor=_parsed_next,
                        request_options=request_options,
                    )

                return AsyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
