"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const lambda = require("aws-cdk-lib/aws-lambda");
const iam = require("aws-cdk-lib/aws-iam");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-solutions-constructs/core");
const integ_tests_alpha_1 = require("@aws-cdk/integ-tests-alpha");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, (0, core_1.generateIntegStackName)(__filename));
(0, core_1.SetConsistentFeatureFlags)(stack);
stack.templateOptions.description = 'Integration Test for aws-lambda-kendra';
stack.node.setContext("@aws-cdk/aws-s3:serverAccessLogsUseBucketPolicy", true);
const testBucket = defaults.CreateScrapBucket(stack, "scrapBucket");
const secondTestBucket = defaults.CreateScrapBucket(stack, "secondScrapBucket");
const existingIamRole = new iam.Role(stack, 'existingRole', {
    assumedBy: new iam.ServicePrincipal('kendra.amazonaws.com')
});
const sourceProps = {
    urls: {
        seedUrlConfiguration: {
            seedUrls: ["https://aws.amazon.com"]
        }
    },
    crawlDepth: 1,
};
const webCrawlerSource = {
    name: "web-source",
    roleArn: existingIamRole.roleArn,
    type: "WEBCRAWLER",
    dataSourceConfiguration: {
        webCrawlerConfiguration: sourceProps
    }
};
new lib_1.LambdaToKendra(stack, 'multiple-sources', {
    lambdaFunctionProps: {
        code: lambda.Code.fromAsset(`lambda`),
        runtime: defaults.COMMERCIAL_REGION_LAMBDA_NODE_RUNTIME,
        handler: 'index.handler',
    },
    kendraDataSourcesProps: [{
            type: 'S3',
            dataSourceConfiguration: {
                s3Configuration: {
                    bucketName: testBucket.bucketName,
                }
            }
        },
        {
            type: 'S3',
            dataSourceConfiguration: {
                s3Configuration: {
                    bucketName: secondTestBucket.bucketName,
                }
            }
        },
        webCrawlerSource],
});
(0, core_1.suppressCustomHandlerCfnNagWarnings)(stack, 'Custom::S3AutoDeleteObjectsCustomResourceProvider');
// Synth
new integ_tests_alpha_1.IntegTest(stack, 'Integ', { testCases: [
        stack
    ] });
//# sourceMappingURL=data:application/json;base64,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