# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.10.2076

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictStr, conint, constr

from typing import Optional

from vrt_lss_studio.models.table_location_column_type import TableLocationColumnType
from vrt_lss_studio.models.table_location_filter_list import TableLocationFilterList
from vrt_lss_studio.models.table_location_list import TableLocationList
from vrt_lss_studio.models.web_location import WebLocation
from vrt_lss_studio.models.web_location_geopoint_list import WebLocationGeopointList

from vrt_lss_studio.api_client import ApiClient
from vrt_lss_studio.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class LocationsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_location(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], web_location : Annotated[WebLocation, Field(..., description="New essence creation request.")], **kwargs) -> WebLocation:  # noqa: E501
        """Create location  # noqa: E501

        Create location.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_location(experiment_key, web_location, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param web_location: New essence creation request. (required)
        :type web_location: WebLocation
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WebLocation
        """
        kwargs['_return_http_data_only'] = True
        return self.create_location_with_http_info(experiment_key, web_location, **kwargs)  # noqa: E501

    @validate_arguments
    def create_location_with_http_info(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], web_location : Annotated[WebLocation, Field(..., description="New essence creation request.")], **kwargs):  # noqa: E501
        """Create location  # noqa: E501

        Create location.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_location_with_http_info(experiment_key, web_location, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param web_location: New essence creation request. (required)
        :type web_location: WebLocation
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WebLocation, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'web_location'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_location" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['web_location']:
            _body_params = _params['web_location']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '201': "WebLocation",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/locations', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_location(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], essence_key : Annotated[Optional[constr(strict=True, max_length=1024, min_length=1)], Field(..., description="Key, unique identifier.")], **kwargs) -> None:  # noqa: E501
        """Remove location  # noqa: E501

        Removing a location by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_location(experiment_key, essence_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param essence_key: Key, unique identifier. (required)
        :type essence_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_location_with_http_info(experiment_key, essence_key, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_location_with_http_info(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], essence_key : Annotated[Optional[constr(strict=True, max_length=1024, min_length=1)], Field(..., description="Key, unique identifier.")], **kwargs):  # noqa: E501
        """Remove location  # noqa: E501

        Removing a location by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_location_with_http_info(experiment_key, essence_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param essence_key: Key, unique identifier. (required)
        :type essence_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'essence_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_location" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']

        if _params['essence_key']:
            _path_params['essence_key'] = _params['essence_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/locations/{essence_key}', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_location(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], essence_key : Annotated[Optional[constr(strict=True, max_length=1024, min_length=1)], Field(..., description="Key, unique identifier.")], **kwargs) -> WebLocation:  # noqa: E501
        """Read location  # noqa: E501

        Getting location information by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_location(experiment_key, essence_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param essence_key: Key, unique identifier. (required)
        :type essence_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WebLocation
        """
        kwargs['_return_http_data_only'] = True
        return self.read_location_with_http_info(experiment_key, essence_key, **kwargs)  # noqa: E501

    @validate_arguments
    def read_location_with_http_info(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], essence_key : Annotated[Optional[constr(strict=True, max_length=1024, min_length=1)], Field(..., description="Key, unique identifier.")], **kwargs):  # noqa: E501
        """Read location  # noqa: E501

        Getting location information by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_location_with_http_info(experiment_key, essence_key, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param essence_key: Key, unique identifier. (required)
        :type essence_key: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WebLocation, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'essence_key'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_location" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']

        if _params['essence_key']:
            _path_params['essence_key'] = _params['essence_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "WebLocation",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/locations/{essence_key}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_locations(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], offset : Annotated[Optional[conint(strict=True, le=10000000, ge=0)], Field(description="The number of items to skip before starting to collect the result set.")] = None, limit : Annotated[Optional[conint(strict=True, le=10000000, ge=1)], Field(description="The number of items to return.")] = None, sort_field : Annotated[Optional[TableLocationColumnType], Field(description="Locations table column name. ")] = None, sort_direction : Annotated[Optional[StrictStr], Field(description="Sort direction.")] = None, table_location_filter_list : Annotated[Optional[TableLocationFilterList], Field(description="locations filter.")] = None, **kwargs) -> TableLocationList:  # noqa: E501
        """Locations list  # noqa: E501

        Getting a locations list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_locations(experiment_key, offset, limit, sort_field, sort_direction, table_location_filter_list, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param offset: The number of items to skip before starting to collect the result set.
        :type offset: int
        :param limit: The number of items to return.
        :type limit: int
        :param sort_field: Locations table column name. 
        :type sort_field: TableLocationColumnType
        :param sort_direction: Sort direction.
        :type sort_direction: str
        :param table_location_filter_list: locations filter.
        :type table_location_filter_list: TableLocationFilterList
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TableLocationList
        """
        kwargs['_return_http_data_only'] = True
        return self.read_locations_with_http_info(experiment_key, offset, limit, sort_field, sort_direction, table_location_filter_list, **kwargs)  # noqa: E501

    @validate_arguments
    def read_locations_with_http_info(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], offset : Annotated[Optional[conint(strict=True, le=10000000, ge=0)], Field(description="The number of items to skip before starting to collect the result set.")] = None, limit : Annotated[Optional[conint(strict=True, le=10000000, ge=1)], Field(description="The number of items to return.")] = None, sort_field : Annotated[Optional[TableLocationColumnType], Field(description="Locations table column name. ")] = None, sort_direction : Annotated[Optional[StrictStr], Field(description="Sort direction.")] = None, table_location_filter_list : Annotated[Optional[TableLocationFilterList], Field(description="locations filter.")] = None, **kwargs):  # noqa: E501
        """Locations list  # noqa: E501

        Getting a locations list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_locations_with_http_info(experiment_key, offset, limit, sort_field, sort_direction, table_location_filter_list, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param offset: The number of items to skip before starting to collect the result set.
        :type offset: int
        :param limit: The number of items to return.
        :type limit: int
        :param sort_field: Locations table column name. 
        :type sort_field: TableLocationColumnType
        :param sort_direction: Sort direction.
        :type sort_direction: str
        :param table_location_filter_list: locations filter.
        :type table_location_filter_list: TableLocationFilterList
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TableLocationList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'offset',
            'limit',
            'sort_field',
            'sort_direction',
            'table_location_filter_list'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_locations" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))

        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))

        if _params.get('sort_field') is not None:  # noqa: E501
            _query_params.append(('sort_field', _params['sort_field']))

        if _params.get('sort_direction') is not None:  # noqa: E501
            _query_params.append(('sort_direction', _params['sort_direction']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['table_location_filter_list']:
            _body_params = _params['table_location_filter_list']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "TableLocationList",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/locations/batch/list', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def read_locations_geopoints(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], table_location_filter_list : Annotated[Optional[TableLocationFilterList], Field(description="Locations filter.")] = None, **kwargs) -> WebLocationGeopointList:  # noqa: E501
        """Location geopoints  # noqa: E501

        Getting a geopoints.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_locations_geopoints(experiment_key, table_location_filter_list, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param table_location_filter_list: Locations filter.
        :type table_location_filter_list: TableLocationFilterList
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WebLocationGeopointList
        """
        kwargs['_return_http_data_only'] = True
        return self.read_locations_geopoints_with_http_info(experiment_key, table_location_filter_list, **kwargs)  # noqa: E501

    @validate_arguments
    def read_locations_geopoints_with_http_info(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], table_location_filter_list : Annotated[Optional[TableLocationFilterList], Field(description="Locations filter.")] = None, **kwargs):  # noqa: E501
        """Location geopoints  # noqa: E501

        Getting a geopoints.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.read_locations_geopoints_with_http_info(experiment_key, table_location_filter_list, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param table_location_filter_list: Locations filter.
        :type table_location_filter_list: TableLocationFilterList
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WebLocationGeopointList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'table_location_filter_list'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_locations_geopoints" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['table_location_filter_list']:
            _body_params = _params['table_location_filter_list']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "WebLocationGeopointList",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/locations/batch/geopoints', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_location(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], web_location : Annotated[WebLocation, Field(..., description="Essence update request.")], **kwargs) -> WebLocation:  # noqa: E501
        """Update location  # noqa: E501

        Updating the location by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_location(experiment_key, web_location, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param web_location: Essence update request. (required)
        :type web_location: WebLocation
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WebLocation
        """
        kwargs['_return_http_data_only'] = True
        return self.update_location_with_http_info(experiment_key, web_location, **kwargs)  # noqa: E501

    @validate_arguments
    def update_location_with_http_info(self, experiment_key : Annotated[constr(strict=True, max_length=256, min_length=2), Field(..., description="Key, unique identifier.")], web_location : Annotated[WebLocation, Field(..., description="Essence update request.")], **kwargs):  # noqa: E501
        """Update location  # noqa: E501

        Updating the location by key.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_location_with_http_info(experiment_key, web_location, async_req=True)
        >>> result = thread.get()

        :param experiment_key: Key, unique identifier. (required)
        :type experiment_key: str
        :param web_location: Essence update request. (required)
        :type web_location: WebLocation
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WebLocation, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'experiment_key',
            'web_location'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_location" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['experiment_key']:
            _path_params['experiment_key'] = _params['experiment_key']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['web_location']:
            _body_params = _params['web_location']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuth']  # noqa: E501

        _response_types_map = {
            '200': "WebLocation",
            '400': "Custom400WithErrorsAndWarnings",
            '401': "General401",
            '402': "General402",
            '403': "General403",
            '404': "General404",
            '405': None,
            '406': None,
            '415': None,
            '429': "General429",
            '500': "General500",
            '501': None,
            '502': None,
            '503': None,
            '504': None,
        }

        return self.api_client.call_api(
            '/studio/experiments/{experiment_key}/locations', 'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
