# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.10.2076

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, confloat, conint

class Capacity(BaseModel):
    """
    Capacity characteristics.
    """
    mass: Optional[Union[confloat(le=1000000, ge=0, strict=True), conint(le=1000000, ge=0, strict=True)]] = Field(0, description="Weight in kilograms.")
    volume: Optional[Union[confloat(le=1000000, ge=0, strict=True), conint(le=1000000, ge=0, strict=True)]] = Field(0, description="Volume in cubic meters.")
    capacity_a: Optional[Union[confloat(le=1000000, ge=0, strict=True), conint(le=1000000, ge=0, strict=True)]] = Field(0, description="Additional parameter (A) for measuring cargoes and compartments in alternative units. For example, to account for cargo in pieces (this parameter is equal to one for a cargo and the maximum number of cargo to hold for a compartment). ")
    capacity_b: Optional[Union[confloat(le=1000000, ge=0, strict=True), conint(le=1000000, ge=0, strict=True)]] = Field(0, description="Additional parameter (B) for measuring cargoes and compartments in alternative units. ")
    capacity_c: Optional[Union[confloat(le=1000000, ge=0, strict=True), conint(le=1000000, ge=0, strict=True)]] = Field(0, description="Additional parameter (C) for measuring cargoes and compartments in alternative units. ")
    __properties = ["mass", "volume", "capacity_a", "capacity_b", "capacity_c"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Capacity:
        """Create an instance of Capacity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Capacity:
        """Create an instance of Capacity from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Capacity.parse_obj(obj)

        _obj = Capacity.parse_obj({
            "mass": obj.get("mass") if obj.get("mass") is not None else 0,
            "volume": obj.get("volume") if obj.get("volume") is not None else 0,
            "capacity_a": obj.get("capacity_a") if obj.get("capacity_a") is not None else 0,
            "capacity_b": obj.get("capacity_b") if obj.get("capacity_b") is not None else 0,
            "capacity_c": obj.get("capacity_c") if obj.get("capacity_c") is not None else 0
        })
        return _obj

