# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.10.2076

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, conint, constr
from vrt_lss_studio.models.experiment_calculation import ExperimentCalculation
from vrt_lss_studio.models.experiment_check import ExperimentCheck
from vrt_lss_studio.models.experiment_settings import ExperimentSettings
from vrt_lss_studio.models.experiment_specification import ExperimentSpecification
from vrt_lss_studio.models.experiment_statistics import ExperimentStatistics

class Experiment(BaseModel):
    """
    Experiment.
    """
    key: constr(strict=True, max_length=256, min_length=2) = Field(..., description="Key, unique identifier.")
    specification: ExperimentSpecification = Field(...)
    settings: ExperimentSettings = Field(...)
    statistics: ExperimentStatistics = Field(...)
    progress: Optional[conint(strict=True, le=100, ge=0)] = Field(0, description="Calculation progress as a percentage. The progress displays the current number of completed steps. ")
    calculation: Optional[ExperimentCalculation] = None
    check: Optional[ExperimentCheck] = None
    pristine: StrictBool = Field(..., description="A flag indicating whether changes to the entity have been made relative to the original data. `true` - means that the data is original and has not been changed. ")
    sharing: Optional[StrictBool] = Field(False, description="Experiment sharing flag. ")
    edit_date: datetime = Field(..., description="Last edit date and time in the [RFC 3339, section 5.6 (ISO 8601)](https://tools.ietf.org/html/rfc3339#section-5.6) format. ")
    creation_date: datetime = Field(..., description="Creation date and time in the [RFC 3339, section 5.6 (ISO 8601)](https://tools.ietf.org/html/rfc3339#section-5.6) format. ")
    __properties = ["key", "specification", "settings", "statistics", "progress", "calculation", "check", "pristine", "sharing", "edit_date", "creation_date"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Experiment:
        """Create an instance of Experiment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "pristine",
                            "sharing",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of specification
        if self.specification:
            _dict['specification'] = self.specification.to_dict()
        # override the default output from pydantic by calling `to_dict()` of settings
        if self.settings:
            _dict['settings'] = self.settings.to_dict()
        # override the default output from pydantic by calling `to_dict()` of statistics
        if self.statistics:
            _dict['statistics'] = self.statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of calculation
        if self.calculation:
            _dict['calculation'] = self.calculation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of check
        if self.check:
            _dict['check'] = self.check.to_dict()
        # set to None if calculation (nullable) is None
        # and __fields_set__ contains the field
        if self.calculation is None and "calculation" in self.__fields_set__:
            _dict['calculation'] = None

        # set to None if check (nullable) is None
        # and __fields_set__ contains the field
        if self.check is None and "check" in self.__fields_set__:
            _dict['check'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Experiment:
        """Create an instance of Experiment from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Experiment.parse_obj(obj)

        _obj = Experiment.parse_obj({
            "key": obj.get("key"),
            "specification": ExperimentSpecification.from_dict(obj.get("specification")) if obj.get("specification") is not None else None,
            "settings": ExperimentSettings.from_dict(obj.get("settings")) if obj.get("settings") is not None else None,
            "statistics": ExperimentStatistics.from_dict(obj.get("statistics")) if obj.get("statistics") is not None else None,
            "progress": obj.get("progress") if obj.get("progress") is not None else 0,
            "calculation": ExperimentCalculation.from_dict(obj.get("calculation")) if obj.get("calculation") is not None else None,
            "check": ExperimentCheck.from_dict(obj.get("check")) if obj.get("check") is not None else None,
            "pristine": obj.get("pristine") if obj.get("pristine") is not None else True,
            "sharing": obj.get("sharing") if obj.get("sharing") is not None else False,
            "edit_date": obj.get("edit_date"),
            "creation_date": obj.get("creation_date")
        })
        return _obj

