# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.10.2076

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, conlist
from vrt_lss_studio.models.experiment import Experiment

class ExperimentList(BaseModel):
    """
    A list of experiments.
    """
    experiments: conlist(Experiment, max_items=101, min_items=0) = Field(..., description="A list of experiments.")
    __properties = ["experiments"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExperimentList:
        """Create an instance of ExperimentList from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in experiments (list)
        _items = []
        if self.experiments:
            for _item in self.experiments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['experiments'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExperimentList:
        """Create an instance of ExperimentList from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ExperimentList.parse_obj(obj)

        _obj = ExperimentList.parse_obj({
            "experiments": [Experiment.from_dict(_item) for _item in obj.get("experiments")] if obj.get("experiments") is not None else None
        })
        return _obj

