# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.10.2076

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, conlist, constr
from vrt_lss_studio.models.hardlink_element import HardlinkElement

class Hardlink(BaseModel):
    """
    Assignment required to associate entities in a single group. It can consist of two or more entities. Example:   * driver assignment to the transport (connection between the performer's shifts and the transport).   * order assignment to the performer (link the order to a performer's shift).   * specifying the need to perform multiple orders during a single trip (linking orders to deliver them within one trip). 
    """
    key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Hardlink key.")
    links: conlist(HardlinkElement, max_items=1000, min_items=2) = Field(..., description="List of items in the assignment group.")
    __properties = ["key", "links"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Hardlink:
        """Create an instance of Hardlink from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item in self.links:
                if _item:
                    _items.append(_item.to_dict())
            _dict['links'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Hardlink:
        """Create an instance of Hardlink from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Hardlink.parse_obj(obj)

        _obj = Hardlink.parse_obj({
            "key": obj.get("key"),
            "links": [HardlinkElement.from_dict(_item) for _item in obj.get("links")] if obj.get("links") is not None else None
        })
        return _obj

