# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.10.2076

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, confloat, conint, constr, validator
from vrt_lss_studio.models.time_window import TimeWindow

class PossibleEvent(BaseModel):
    """
    Possible event.  Combines the geographical location and the time window, when a demand can be completed. 
    """
    key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Event key, unique identifier.")
    location_key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Location key, where this event is possible.")
    duration: Optional[constr(strict=True, max_length=16, min_length=3)] = Field('PT0S', description="Time duration according to [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). ")
    reward: Optional[Union[confloat(le=1000000000, ge=0, strict=True), conint(le=1000000000, ge=0, strict=True)]] = Field(1000.1, description="Reward for the event.")
    hard_time_window: Optional[TimeWindow] = Field(...)
    soft_time_window: Optional[TimeWindow] = None
    __properties = ["key", "location_key", "duration", "reward", "hard_time_window", "soft_time_window"]

    @validator('duration')
    def duration_validate_regular_expression(cls, v):
        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", v):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PossibleEvent:
        """Create an instance of PossibleEvent from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of hard_time_window
        if self.hard_time_window:
            _dict['hard_time_window'] = self.hard_time_window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of soft_time_window
        if self.soft_time_window:
            _dict['soft_time_window'] = self.soft_time_window.to_dict()
        # set to None if hard_time_window (nullable) is None
        # and __fields_set__ contains the field
        if self.hard_time_window is None and "hard_time_window" in self.__fields_set__:
            _dict['hard_time_window'] = None

        # set to None if soft_time_window (nullable) is None
        # and __fields_set__ contains the field
        if self.soft_time_window is None and "soft_time_window" in self.__fields_set__:
            _dict['soft_time_window'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PossibleEvent:
        """Create an instance of PossibleEvent from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PossibleEvent.parse_obj(obj)

        _obj = PossibleEvent.parse_obj({
            "key": obj.get("key"),
            "location_key": obj.get("location_key"),
            "duration": obj.get("duration") if obj.get("duration") is not None else 'PT0S',
            "reward": obj.get("reward") if obj.get("reward") is not None else 1000.1,
            "hard_time_window": TimeWindow.from_dict(obj.get("hard_time_window")) if obj.get("hard_time_window") is not None else None,
            "soft_time_window": TimeWindow.from_dict(obj.get("soft_time_window")) if obj.get("soft_time_window") is not None else None
        })
        return _obj

