# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.10.2076

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field
from vrt_lss_studio.models.table_filter_bool_list import TableFilterBoolList
from vrt_lss_studio.models.table_filter_datetime_range import TableFilterDatetimeRange
from vrt_lss_studio.models.table_filter_enum_list import TableFilterEnumList
from vrt_lss_studio.models.table_filter_float_range import TableFilterFloatRange
from vrt_lss_studio.models.table_filter_int_range import TableFilterIntRange
from vrt_lss_studio.models.table_filter_string_list import TableFilterStringList
from vrt_lss_studio.models.table_filter_string_search import TableFilterStringSearch
from vrt_lss_studio.models.table_filter_type import TableFilterType
from vrt_lss_studio.models.table_order_column_type import TableOrderColumnType

class TableOrderFilter(BaseModel):
    """
    Universal filter for table.
    """
    type: TableFilterType = Field(...)
    column: TableOrderColumnType = Field(...)
    datetime_range: Optional[TableFilterDatetimeRange] = None
    int_range: Optional[TableFilterIntRange] = None
    float_range: Optional[TableFilterFloatRange] = None
    bool_list: Optional[TableFilterBoolList] = None
    string_list: Optional[TableFilterStringList] = None
    enum_list: Optional[TableFilterEnumList] = None
    string_search: Optional[TableFilterStringSearch] = None
    __properties = ["type", "column", "datetime_range", "int_range", "float_range", "bool_list", "string_list", "enum_list", "string_search"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TableOrderFilter:
        """Create an instance of TableOrderFilter from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of datetime_range
        if self.datetime_range:
            _dict['datetime_range'] = self.datetime_range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of int_range
        if self.int_range:
            _dict['int_range'] = self.int_range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of float_range
        if self.float_range:
            _dict['float_range'] = self.float_range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of bool_list
        if self.bool_list:
            _dict['bool_list'] = self.bool_list.to_dict()
        # override the default output from pydantic by calling `to_dict()` of string_list
        if self.string_list:
            _dict['string_list'] = self.string_list.to_dict()
        # override the default output from pydantic by calling `to_dict()` of enum_list
        if self.enum_list:
            _dict['enum_list'] = self.enum_list.to_dict()
        # override the default output from pydantic by calling `to_dict()` of string_search
        if self.string_search:
            _dict['string_search'] = self.string_search.to_dict()
        # set to None if datetime_range (nullable) is None
        # and __fields_set__ contains the field
        if self.datetime_range is None and "datetime_range" in self.__fields_set__:
            _dict['datetime_range'] = None

        # set to None if int_range (nullable) is None
        # and __fields_set__ contains the field
        if self.int_range is None and "int_range" in self.__fields_set__:
            _dict['int_range'] = None

        # set to None if float_range (nullable) is None
        # and __fields_set__ contains the field
        if self.float_range is None and "float_range" in self.__fields_set__:
            _dict['float_range'] = None

        # set to None if bool_list (nullable) is None
        # and __fields_set__ contains the field
        if self.bool_list is None and "bool_list" in self.__fields_set__:
            _dict['bool_list'] = None

        # set to None if string_list (nullable) is None
        # and __fields_set__ contains the field
        if self.string_list is None and "string_list" in self.__fields_set__:
            _dict['string_list'] = None

        # set to None if enum_list (nullable) is None
        # and __fields_set__ contains the field
        if self.enum_list is None and "enum_list" in self.__fields_set__:
            _dict['enum_list'] = None

        # set to None if string_search (nullable) is None
        # and __fields_set__ contains the field
        if self.string_search is None and "string_search" in self.__fields_set__:
            _dict['string_search'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TableOrderFilter:
        """Create an instance of TableOrderFilter from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TableOrderFilter.parse_obj(obj)

        _obj = TableOrderFilter.parse_obj({
            "type": obj.get("type"),
            "column": obj.get("column"),
            "datetime_range": TableFilterDatetimeRange.from_dict(obj.get("datetime_range")) if obj.get("datetime_range") is not None else None,
            "int_range": TableFilterIntRange.from_dict(obj.get("int_range")) if obj.get("int_range") is not None else None,
            "float_range": TableFilterFloatRange.from_dict(obj.get("float_range")) if obj.get("float_range") is not None else None,
            "bool_list": TableFilterBoolList.from_dict(obj.get("bool_list")) if obj.get("bool_list") is not None else None,
            "string_list": TableFilterStringList.from_dict(obj.get("string_list")) if obj.get("string_list") is not None else None,
            "enum_list": TableFilterEnumList.from_dict(obj.get("enum_list")) if obj.get("enum_list") is not None else None,
            "string_search": TableFilterStringSearch.from_dict(obj.get("string_search")) if obj.get("string_search") is not None else None
        })
        return _obj

