# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.10.2076

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist, constr

class TransportCompatibilities(BaseModel):
    """
    Transport [compatibilities](#section/Description/Compatibilities). 
    """
    transport_features: Optional[conlist(constr(strict=True, max_length=256, min_length=1), max_items=1000, min_items=0, unique_items=True)] = Field(None, description="Transport features list, it is used to check whether the transport is compatible with locations and performers. ")
    performer_restrictions: Optional[conlist(constr(strict=True, max_length=256, min_length=1), max_items=1000, min_items=0, unique_items=True)] = Field(None, description="Requirements list for the performer. Used for checking the compatibility of the performer and the order (work). ")
    __properties = ["transport_features", "performer_restrictions"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransportCompatibilities:
        """Create an instance of TransportCompatibilities from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransportCompatibilities:
        """Create an instance of TransportCompatibilities from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TransportCompatibilities.parse_obj(obj)

        _obj = TransportCompatibilities.parse_obj({
            "transport_features": obj.get("transport_features"),
            "performer_restrictions": obj.get("performer_restrictions")
        })
        return _obj

