# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.10.2076

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, conint, constr, validator
from vrt_lss_studio.models.geopoint import Geopoint

class WebTransportGeopoint(BaseModel):
    """
    Geopoint for map.
    """
    geopoint: Geopoint = Field(...)
    transport_key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Transport's key.")
    shift_key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Shift key, unique identifier.")
    point_type: StrictStr = Field(..., description="The point type.")
    trip_key: Optional[constr(strict=True, max_length=1024, min_length=1)] = Field(None, description="Key, unique identifier.")
    trip_name: Optional[constr(strict=True, max_length=64, min_length=0)] = Field('', description="Trip name.")
    stop_number: Optional[conint(strict=True, le=1000, ge=0)] = Field(0, description="Sequence number of the stop in the trip.")
    __properties = ["geopoint", "transport_key", "shift_key", "point_type", "trip_key", "trip_name", "stop_number"]

    @validator('point_type')
    def point_type_validate_enum(cls, v):
        if v not in ('START', 'FINISH'):
            raise ValueError("must be one of enum values ('START', 'FINISH')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WebTransportGeopoint:
        """Create an instance of WebTransportGeopoint from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of geopoint
        if self.geopoint:
            _dict['geopoint'] = self.geopoint.to_dict()
        # set to None if trip_key (nullable) is None
        # and __fields_set__ contains the field
        if self.trip_key is None and "trip_key" in self.__fields_set__:
            _dict['trip_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WebTransportGeopoint:
        """Create an instance of WebTransportGeopoint from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return WebTransportGeopoint.parse_obj(obj)

        _obj = WebTransportGeopoint.parse_obj({
            "geopoint": Geopoint.from_dict(obj.get("geopoint")) if obj.get("geopoint") is not None else None,
            "transport_key": obj.get("transport_key"),
            "shift_key": obj.get("shift_key"),
            "point_type": obj.get("point_type"),
            "trip_key": obj.get("trip_key"),
            "trip_name": obj.get("trip_name") if obj.get("trip_name") is not None else '',
            "stop_number": obj.get("stop_number") if obj.get("stop_number") is not None else 0
        })
        return _obj

