# coding: utf-8

"""
    VRt.Studio [ST]

    The version of the OpenAPI document: 6.10.2076

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist
from vrt_lss_studio.models.linked_essence import LinkedEssence
from vrt_lss_studio.models.table_trip_fields import TableTripFields
from vrt_lss_studio.models.trip import Trip
from vrt_lss_studio.models.trip_statistics import TripStatistics

class WebTrip(BaseModel):
    """
    Web Trip.
    """
    trip: Trip = Field(...)
    trip_statistics: TripStatistics = Field(...)
    fields: Optional[TableTripFields] = None
    linked_essences: Optional[conlist(LinkedEssence, max_items=15001, min_items=0)] = Field(None, description="A list of linked essences.")
    __properties = ["trip", "trip_statistics", "fields", "linked_essences"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WebTrip:
        """Create an instance of WebTrip from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of trip
        if self.trip:
            _dict['trip'] = self.trip.to_dict()
        # override the default output from pydantic by calling `to_dict()` of trip_statistics
        if self.trip_statistics:
            _dict['trip_statistics'] = self.trip_statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fields
        if self.fields:
            _dict['fields'] = self.fields.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in linked_essences (list)
        _items = []
        if self.linked_essences:
            for _item in self.linked_essences:
                if _item:
                    _items.append(_item.to_dict())
            _dict['linked_essences'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WebTrip:
        """Create an instance of WebTrip from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return WebTrip.parse_obj(obj)

        _obj = WebTrip.parse_obj({
            "trip": Trip.from_dict(obj.get("trip")) if obj.get("trip") is not None else None,
            "trip_statistics": TripStatistics.from_dict(obj.get("trip_statistics")) if obj.get("trip_statistics") is not None else None,
            "fields": TableTripFields.from_dict(obj.get("fields")) if obj.get("fields") is not None else None,
            "linked_essences": [LinkedEssence.from_dict(_item) for _item in obj.get("linked_essences")] if obj.get("linked_essences") is not None else None
        })
        return _obj

