# coding: utf-8

"""
    Cashfree LRS

    CashFree LRS APIs (v2)  # noqa: E501

    The version of the OpenAPI document: 1.0.10
    Contact: nextgenapi@cashfree.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, StrictInt, conlist
from cashfree_lrs_client.models.document import Document

class BulkDocumentsUploadResponse(BaseModel):
    """
    BulkDocumentsUploadResponse
    """
    bulk_doc_id: Optional[StrictInt] = None
    uploaded_documents: Optional[conlist(Document)] = None
    upload_failed_documents: Optional[conlist(Document)] = None
    __properties = ["bulk_doc_id", "uploaded_documents", "upload_failed_documents"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BulkDocumentsUploadResponse:
        """Create an instance of BulkDocumentsUploadResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "bulk_doc_id",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in uploaded_documents (list)
        _items = []
        if self.uploaded_documents:
            for _item in self.uploaded_documents:
                if _item:
                    _items.append(_item.to_dict())
            _dict['uploaded_documents'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in upload_failed_documents (list)
        _items = []
        if self.upload_failed_documents:
            for _item in self.upload_failed_documents:
                if _item:
                    _items.append(_item.to_dict())
            _dict['upload_failed_documents'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BulkDocumentsUploadResponse:
        """Create an instance of BulkDocumentsUploadResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return BulkDocumentsUploadResponse.parse_obj(obj)

        _obj = BulkDocumentsUploadResponse.parse_obj({
            "bulk_doc_id": obj.get("bulk_doc_id"),
            "uploaded_documents": [Document.from_dict(_item) for _item in obj.get("uploaded_documents")] if obj.get("uploaded_documents") is not None else None,
            "upload_failed_documents": [Document.from_dict(_item) for _item in obj.get("upload_failed_documents")] if obj.get("upload_failed_documents") is not None else None
        })
        return _obj

