# coding: utf-8

"""
    Cashfree LRS

    CashFree LRS APIs (v2)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: nextgenapi@cashfree.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, StrictStr, confloat, conlist

class OrderResponse(BaseModel):
    """
    OrderResponse
    """
    tcs: Optional[confloat(ge=0, strict=True)] = None
    gst: Optional[confloat(ge=0, strict=True)] = None
    fx_rate: Optional[confloat(ge=0, strict=True)] = None
    amount_to_pay: Optional[confloat(ge=0, strict=True)] = None
    handling_charges: Optional[confloat(ge=0, strict=True)] = None
    order_expiry_time: Optional[datetime] = None
    payment_link: Optional[StrictStr] = None
    order_token: Optional[StrictStr] = None
    missing_documents: Optional[conlist(StrictStr)] = None
    __properties = ["tcs", "gst", "fx_rate", "amount_to_pay", "handling_charges", "order_expiry_time", "payment_link", "order_token", "missing_documents"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OrderResponse:
        """Create an instance of OrderResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrderResponse:
        """Create an instance of OrderResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OrderResponse.parse_obj(obj)

        _obj = OrderResponse.parse_obj({
            "tcs": obj.get("tcs"),
            "gst": obj.get("gst"),
            "fx_rate": obj.get("fx_rate"),
            "amount_to_pay": obj.get("amount_to_pay"),
            "handling_charges": obj.get("handling_charges"),
            "order_expiry_time": obj.get("order_expiry_time"),
            "payment_link": obj.get("payment_link"),
            "order_token": obj.get("order_token"),
            "missing_documents": obj.get("missing_documents")
        })
        return _obj

