"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bundle = void 0;
const fs = require("fs");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
/**
 * Produce bundled Lambda asset code
 */
function bundle(options) {
    let installer = options.runtime === lambda.Runtime.PYTHON_2_7 ? Installer.PIP : Installer.PIP3;
    let hasRequirements = fs.existsSync(path.join(options.entry, 'requirements.txt'));
    let depsCommand = chain([
        hasRequirements ? `${installer} install -r requirements.txt -t ${cdk.AssetStaging.BUNDLING_OUTPUT_DIR}` : '',
        `cp -au . ${cdk.AssetStaging.BUNDLING_OUTPUT_DIR}`,
    ]);
    return lambda.Code.fromAsset(options.entry, {
        bundling: {
            image: options.runtime.bundlingDockerImage,
            command: ['bash', '-c', depsCommand],
        },
    });
}
exports.bundle = bundle;
var Installer;
(function (Installer) {
    Installer["PIP"] = "pip";
    Installer["PIP3"] = "pip3";
})(Installer || (Installer = {}));
function chain(commands) {
    return commands.filter(c => !!c).join(' && ');
}
//# sourceMappingURL=data:application/json;base64,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