"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.captureStackTrace = void 0;
function captureStackTrace(below) {
    if (process.env.CDK_DISABLE_STACK_TRACE) {
        return ['stack traces disabled'];
    }
    below = below || captureStackTrace; // hide myself if nothing else
    const object = { stack: '' };
    const previousLimit = Error.stackTraceLimit;
    try {
        Error.stackTraceLimit = Number.MAX_SAFE_INTEGER;
        Error.captureStackTrace(object, below);
    }
    finally {
        Error.stackTraceLimit = previousLimit;
    }
    if (!object.stack) {
        return [];
    }
    return object.stack.split('\n').slice(1).map(s => s.replace(/^\s*at\s+/, ''));
}
exports.captureStackTrace = captureStackTrace;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RhY2stdHJhY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzdGFjay10cmFjZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxTQUFnQixpQkFBaUIsQ0FBQyxLQUFnQjtJQUNoRCxJQUFJLE9BQU8sQ0FBQyxHQUFHLENBQUMsdUJBQXVCLEVBQUU7UUFDdkMsT0FBTyxDQUFDLHVCQUF1QixDQUFDLENBQUM7S0FDbEM7SUFFRCxLQUFLLEdBQUcsS0FBSyxJQUFJLGlCQUFpQixDQUFDLENBQUMsOEJBQThCO0lBQ2xFLE1BQU0sTUFBTSxHQUFHLEVBQUUsS0FBSyxFQUFFLEVBQUUsRUFBRSxDQUFDO0lBQzdCLE1BQU0sYUFBYSxHQUFHLEtBQUssQ0FBQyxlQUFlLENBQUM7SUFDNUMsSUFBSTtRQUNGLEtBQUssQ0FBQyxlQUFlLEdBQUcsTUFBTSxDQUFDLGdCQUFnQixDQUFDO1FBQ2hELEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFNLEVBQUUsS0FBSyxDQUFDLENBQUM7S0FDeEM7WUFBUztRQUNSLEtBQUssQ0FBQyxlQUFlLEdBQUcsYUFBYSxDQUFDO0tBQ3ZDO0lBQ0QsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUU7UUFDakIsT0FBTyxFQUFFLENBQUM7S0FDWDtJQUNELE9BQU8sTUFBTSxDQUFDLEtBQUssQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsV0FBVyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUM7QUFDaEYsQ0FBQztBQWxCRCw4Q0FrQkMiLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgZnVuY3Rpb24gY2FwdHVyZVN0YWNrVHJhY2UoYmVsb3c/OiBGdW5jdGlvbik6IHN0cmluZ1tdIHtcbiAgaWYgKHByb2Nlc3MuZW52LkNES19ESVNBQkxFX1NUQUNLX1RSQUNFKSB7XG4gICAgcmV0dXJuIFsnc3RhY2sgdHJhY2VzIGRpc2FibGVkJ107XG4gIH1cblxuICBiZWxvdyA9IGJlbG93IHx8IGNhcHR1cmVTdGFja1RyYWNlOyAvLyBoaWRlIG15c2VsZiBpZiBub3RoaW5nIGVsc2VcbiAgY29uc3Qgb2JqZWN0ID0geyBzdGFjazogJycgfTtcbiAgY29uc3QgcHJldmlvdXNMaW1pdCA9IEVycm9yLnN0YWNrVHJhY2VMaW1pdDtcbiAgdHJ5IHtcbiAgICBFcnJvci5zdGFja1RyYWNlTGltaXQgPSBOdW1iZXIuTUFYX1NBRkVfSU5URUdFUjtcbiAgICBFcnJvci5jYXB0dXJlU3RhY2tUcmFjZShvYmplY3QsIGJlbG93KTtcbiAgfSBmaW5hbGx5IHtcbiAgICBFcnJvci5zdGFja1RyYWNlTGltaXQgPSBwcmV2aW91c0xpbWl0O1xuICB9XG4gIGlmICghb2JqZWN0LnN0YWNrKSB7XG4gICAgcmV0dXJuIFtdO1xuICB9XG4gIHJldHVybiBvYmplY3Quc3RhY2suc3BsaXQoJ1xcbicpLnNsaWNlKDEpLm1hcChzID0+IHMucmVwbGFjZSgvXlxccyphdFxccysvLCAnJykpO1xufVxuIl19