(function(){RB.Dashboard=Backbone.Model.extend({defaults:{count:0,localSiteName:null},initialize:function(){this.selection=new Backbone.Collection([],{model:RB.ReviewRequest});this.listenTo(this.selection,"add remove reset",function(){this.set("count",this.selection.length)})},select:function(id){var localSiteName=this.get("localSiteName");this.selection.add({id:id,localSitePrefix:localSiteName?"s/"+localSiteName+"/":null})},unselect:function(id){this.selection.remove(this.selection.get(id))},clearSelection:function(){this.selection.reset()},closeReviewRequests:function(options){function closeNext(){if(reviewRequests.length===0){this.selection.reset();this.trigger("refresh");options.onDone(successes,failures);return}reviewRequest=reviewRequests.shift();reviewRequest.close({type:options.closeType,success:function(){successes.push(reviewRequest)},error:function(){failures.push(reviewRequest)},complete:_.bind(closeNext,this)})}var reviewRequests=this.selection.clone(),successes=[],failures=[];closeNext.call(this)}});var DashboardActionsView=Backbone.View.extend({id:"dashboard_actions",template:_.template(['<div id="dashboard_actions_content">',' <p class="count"></p>'," <ul>",'  <li><a class="discard" href="#"><%= close_discarded_text %></li>','  <li><a class="submit" href="#"><%= close_submitted_text %></li>'," </ul>","</div>"].join("")),events:{"click .discard":"_onCloseDiscardedClicked","click .submit":"_onCloseSubmittedClicked"},initialize:function(){this._$content=null;this._$count=null},render:function(){this.$el.hide().html(this.template({close_discarded_text:gettext("<b>Close</b> Discarded"),close_submitted_text:gettext("<b>Close</b> Submitted")}));this._$content=this.$("#dashboard_actions_content");this._$count=this.$(".count");this.listenTo(this.model,"change:count",function(model,count){this._$count.text(interpolate(ngettext("%s review request selected","%s review requests selected",count),[count]))});return this},show:function(){this.$el.fadeIn("fast")},hide:function(){this.$el.fadeOut("fast")},_onCloseDiscardedClicked:function(){this._closeReviewRequests(RB.ReviewRequest.CLOSE_DISCARDED);return false},_onCloseSubmittedClicked:function(){this._closeReviewRequests(RB.ReviewRequest.CLOSE_SUBMITTED);return false},_closeReviewRequests:function(closeType){this._confirmClose(function(){this.model.closeReviewRequests({closeType:closeType,onDone:_.bind(this._showCloseResults,this)})})},_showCloseResults:function(successes,failures){var numSuccesses=successes.length,numFailures=failures.length,$dlg=$("<div/>").append($("<p/>").text(interpolate(ngettext("%s review request has been closed.","%s review requests have been closed.",numSuccesses),[numSuccesses])));if(numFailures>0){$dlg.append($("<p/>").text(interpolate(ngettext("%s review request could not be closed.","%s review requests could not be closed.",numFailures),[numFailures]))).append($("<p/>").text(gettext("You may not have permission to close them.")))}$dlg.modalBox({title:gettext("Close review requests"),buttons:[$('<input type="button"/>').val(gettext("Thanks!"))]})},_confirmClose:function(onConfirmed){$("<div/>").append($("<p/>").text(gettext("If these review requests have unpublished drafts, they will be discarded."))).append($("<p/>").text(gettext("Are you sure you want to close these review requests?"))).modalBox({title:gettext("Close review requests"),buttons:[$('<input type="button"/>').val(gettext("Cancel")),$('<input type="button"/>').val(gettext("Close Review Requests")).click(_.bind(onConfirmed,this))]})}});RB.DashboardView=Backbone.View.extend({RELOAD_INTERVAL_MS:5*60*1e3,events:{"change tbody input[data-checkbox-name=select]":"_onRowSelected","reloaded .datagrid-wrapper":"_setupDashboard"},initialize:function(){this._bottomSpacing=null;this._reloadTimer=null;this._datagrid=null;this._$wrapper=null;this._$datagridBody=null;this._$datagridBodyContainer=null;this._$window=null},render:function(){this._$window=$(window);this.listenTo(this.model,"change:count",function(model,count){if(count>0){this._actionsView.show();this._stopReloadTimer()}else{this._actionsView.hide();this._startReloadTimer()}});this.listenTo(this.model,"refresh",function(){this._reloadDashboard(false)});this._actionsView=new DashboardActionsView({model:this.model});this._actionsView.render();this._setupDashboard();this._startReloadTimer();this._$window.resize(_.bind(this._updateSize,this));return this},_setupDashboard:function(){this._$wrapper=this.$("#dashboard-wrapper");this._$datagrid=this._$wrapper.find(".datagrid-wrapper");this._datagrid=this._$datagrid.data("datagrid");this._$main=this._$wrapper.find(".datagrid-main");this._actionsView.$el.appendTo(this.$("#dashboard_sidebar"));this._actionsView.delegateEvents();this.$("time.timesince").timesince();this.$(".user").user_infobox();this.model.clearSelection();_.each(this.$("input[data-checkbox-name=select]:checked"),function(checkbox){this.model.select($(checkbox).data("object-id"))},this);this._updateSize();this._$datagrid.on("reloaded",_.bind(this._setupDashboard,this))},_startReloadTimer:function(){if(!this._reloadTimer){this._reloadTimer=setInterval(_.bind(this._reloadDashboard,this),this.RELOAD_INTERVAL_MS)}},_stopReloadTimer:function(){if(this._reloadTimer){window.clearInterval(this._reloadTimer);this._reloadTimer=null}},_updateSize:function(){this.$el.show().outerHeight(this._$window.height()-this.$el.offset().top-this._getBottomSpacing());this._datagrid.resizeToFit()},_getBottomSpacing:function(){if(this._bottomSpacing===null){this._bottomSpacing=0;_.each(this.$el.parents(),function(parentEl){this._bottomSpacing+=$(parentEl).getExtents("bmp","b")},this)}return this._bottomSpacing},_reloadDashboard:function(periodicReload){var $editCols=this.$(".edit-columns");if(periodicReload===false){this._stopReloadTimer()}this.model.clearSelection();$editCols.width($editCols.width()-1).children("img").attr({src:STATIC_URLS["rb/images/spinner.gif"],width:"auto",height:"auto"});this._$wrapper.load(window.location+" #dashboard-wrapper",_.bind(function(){this.$(".datagrid-wrapper").datagrid();this._setupDashboard();if(periodicReload!==false){this._startReloadTimer()}},this))},_onRowSelected:function(e){var $checkbox=$(e.target),reviewRequestID=$checkbox.data("object-id");if($checkbox.prop("checked")){this.model.select(reviewRequestID)}else{this.model.unselect(reviewRequestID)}}})}).call(this);