import { IAwsInvoker } from '../aws-invoker';
import { IRunCommandHook, RunCommandOutputs, RunCommandProps } from '../run-command-hook';
import { ISleepHook } from '../sleep-hook';
export interface ApiRunCommandProps {
    readonly awsInvoker: IAwsInvoker;
    readonly sleepHook: ISleepHook;
}
/**
 * RunCommand implementation using AWS API
 */
export declare class ApiRunCommandHook implements IRunCommandHook {
    private static readonly MaximumMaxResultsValue;
    private static readonly SsmInstanceIdsFilterKey;
    private static readonly SsmPingOnlineStatusValue;
    private static readonly RunningStatuses;
    readonly awsInvoker: IAwsInvoker;
    readonly sleepHook: ISleepHook;
    readonly props: ApiRunCommandProps;
    constructor(awsInvoker: IAwsInvoker, sleepHook: ISleepHook);
    execute(props: RunCommandProps): RunCommandOutputs;
    private waitForCommand;
    private getCommandStatus;
    /**
       * We only return status code and output if there is exactly one invocation and one plug-in
       */
    private getSinglePluginStatus;
    private runCommand;
    private getSendCommandProps;
    private adaptRunCommandParameters;
    private validateInstanceIdsAreHealthy;
    private getPingStatusOfInstances;
}
