/**
 * This can be used to provide a hook for sleeping for SleepStep (and other places where sleep is required).
 */
export interface ISleepHook {
    sleep(timeMillis: number): void;
}
/**
 * Performs a real sleep.
 */
export declare class SleepImpl implements ISleepHook {
    /**
       * Synchronously sleeps for duration specified in millis.
       */
    sleep(timeMillis: number): void;
}
/**
 * Mock ISleeper implementation. Simply logs that it is sleeping and returns immediately.
 */
export declare class MockSleep implements ISleepHook {
    readonly sleepMilliInvocations: number[];
    sleep(timeMillis: number): void;
}
