import { Construct } from 'constructs';
import { Output } from '../../domain/output';
import { AwsApiStep, AwsInvocationProps } from './aws-api-step';
/**
 * Properties for AssertAwsResourceStep
 */
export interface AssertAwsResourceStepProps extends AwsInvocationProps {
    /**
       * (Required) Json path selector to extract value from AWS response
       */
    readonly selector: string;
    /**
       * (Required) Value extracted from AWS response desired to be one of these desired values.
       */
    readonly desiredValues: string[];
}
/**
 * AutomationStep implementation of aws:assertAwsResourceProperty.
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-assertAwsResourceProperty.html
 */
export declare class AssertAwsResourceStep extends AwsApiStep {
    readonly selector: string;
    readonly desiredValues: string[];
    readonly action: string;
    constructor(scope: Construct, id: string, props: AssertAwsResourceStepProps);
    /**
       * There are no outputs for this step.
       * @returns empty list
       */
    listOutputs(): Output[];
    toSsmEntry(): {
        [name: string]: any;
    };
}
