"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssertAwsResourceStep = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_api_step_1 = require("./aws-api-step");
/**
 * AutomationStep implementation of aws:assertAwsResourceProperty.
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-assertAwsResourceProperty.html
 */
class AssertAwsResourceStep extends aws_api_step_1.AwsApiStep {
    constructor(scope, id, props) {
        super(scope, id, {
            ...{
                outputs: [],
            },
            ...props,
        });
        this.action = 'aws:assertAwsResourceProperty';
        this.selector = props.selector;
        this.desiredValues = props.desiredValues;
    }
    /**
       * There are no outputs for this step.
       * @returns empty list
       */
    listOutputs() {
        return [];
    }
    toSsmEntry() {
        return super.prepareSsmEntry({
            ...{
                Service: this.service.namespace,
                Api: this.pascalCaseApi,
                PropertySelector: this.selector,
                DesiredValues: this.desiredValues,
            },
            ...this.apiParams.format,
        });
    }
}
exports.AssertAwsResourceStep = AssertAwsResourceStep;
_a = JSII_RTTI_SYMBOL_1;
AssertAwsResourceStep[_a] = { fqn: "@cdklabs/cdk-ssm-documents.AssertAwsResourceStep", version: "0.0.31" };
//# sourceMappingURL=data:application/json;base64,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