import { Construct } from 'constructs';
import { Output } from '../../domain/output';
import { IMapListVariable } from '../../interface/variables/map-list-variable';
import { IStringListVariable } from '../../interface/variables/string-list-variable';
import { HardCodedString, IStringVariable, StringVariable } from '../../interface/variables/string-variable';
import { AutomationStep, AutomationStepProps } from '../automation-step';
/**
 * Properties for CreateTagStep
 */
export interface CreateTagsStepProps extends AutomationStepProps {
    /**
     * The IDs of the resource(s) to be tagged. If resource type isn't “EC2”, this field can contain only a single item.
     */
    readonly resourceIds: IStringListVariable;
    /**
     * The tags to associate with the resource(s).
     */
    readonly tags: IMapListVariable;
    /**
     * (Optional) The type of resource(s) to be tagged.
     * Valid values: EC2 | ManagedInstance | MaintenanceWindow | Parameter
     * @default EC2
     */
    readonly resourceType?: IResourceTypeVariable;
}
export interface IResourceTypeVariable extends IStringVariable {
}
export declare class HardCodedResourceType extends HardCodedString implements IResourceTypeVariable {
    static readonly EC2: HardCodedResourceType;
    static readonly MANAGED_INSTANCE: HardCodedResourceType;
    static readonly MAINTENANCE_WINDOW: HardCodedResourceType;
    static readonly PARAMETER: HardCodedResourceType;
    private constructor();
}
export declare class ResourceTypeVariable extends StringVariable implements IResourceTypeVariable {
    readonly validValues: string[];
    protected assertType(value: any): void;
}
/**
 * AutomationStep implemenation for aws:createTags
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-createtag.html
 */
export declare class CreateTagsStep extends AutomationStep {
    readonly action = "aws:createTags";
    readonly resourceIds: IStringListVariable;
    readonly tags: IMapListVariable;
    readonly resourceType?: IResourceTypeVariable;
    constructor(scope: Construct, id: string, props: CreateTagsStepProps);
    /**
       * This step has no outputs.
       */
    listOutputs(): Output[];
    listInputs(): string[];
    toSsmEntry(): Record<string, any>;
}
