import { Construct } from 'constructs';
import { Output } from '../../domain/output';
import { IMapListVariable } from '../../interface/variables/map-list-variable';
import { INumberVariable } from '../../interface/variables/number-variable';
import { IStringListVariable } from '../../interface/variables/string-list-variable';
import { IStringMapVariable } from '../../interface/variables/string-map-variable';
import { HardCodedString, IStringVariable, StringVariable } from '../../interface/variables/string-variable';
import { AutomationStep, AutomationStepProps } from '../automation-step';
export interface IDocumentHashTypeVariable extends IStringVariable {
}
export declare class HardCodedDocumentHashType extends HardCodedString implements IDocumentHashTypeVariable {
    static readonly SHA256: HardCodedDocumentHashType;
    static readonly SHA1: HardCodedDocumentHashType;
    private constructor();
}
export declare class DocumentHashTypeVariable extends StringVariable implements IDocumentHashTypeVariable {
    readonly validValues: string[];
    protected assertType(value: any): void;
}
/**
 * Properties for RunCommandStep
 */
export interface RunCommandStepProps extends AutomationStepProps {
    /**
       * If the Command type document is owned by you or AWS, specify the name of the document. If you're using a document shared with you by a different AWS account, specify the Amazon Resource Name (ARN) of the document.
       */
    readonly documentName: IStringVariable;
    /**
       * The instance IDs where you want the command to run. You can specify a maximum of 50 IDs.
       *
       * You can also use the pseudo parameter {{ RESOURCE_ID }} in place of instance IDs to run the command on all instances in the target group. For more information about pseudo parameters, see [About pseudo parameters](https://docs.aws.amazon.com/systems-manager/latest/userguide/mw-cli-register-tasks-parameters.html).
       *
       * Another alternative is to send commands to a fleet of instances by using the Targets parameter. The Targets parameter accepts Amazon Elastic Compute Cloud (Amazon EC2) tags. For more information about how to use the Targets parameter, see [Using targets and rate controls to send commands to a fleet](https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html).
       */
    readonly targets: IStringListVariable | IMapListVariable;
    /**
       * (Optional) The required and optional parameters specified in the document.
       */
    readonly parameters?: IStringMapVariable;
    /**
       * (Optional) Configuration options for sending command output to Amazon CloudWatch Logs. For more information about sending command output to CloudWatch Logs, see [Configuring Amazon CloudWatch Logs for Run Command](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-rc-setting-up-cwlogs.html).
       */
    readonly cloudWatchOutputConfig?: IStringMapVariable;
    /**
       * (Optional) User-defined information about the command.
       */
    readonly comment?: IStringVariable;
    /**
       * (Optional) The hash for the document.
       */
    readonly documentHash?: IStringVariable;
    /**
       * (Optional) The type of the hash.
       */
    readonly documentHashType?: IDocumentHashTypeVariable;
    /**
       * (Optional) The configurations for sending notifications.
       */
    readonly notificationConfig?: IStringMapVariable;
    /**
       * (Optional) The name of the S3 bucket for command output responses.
       */
    readonly outputS3BucketName?: IStringVariable;
    /**
       * (Optional) The prefix.
       */
    readonly outputS3KeyPrefix?: IStringVariable;
    /**
       * (Optional) The ARN of the AWS Identity and Access Management (IAM) role.
       */
    readonly serviceRoleArn?: IStringVariable;
    /**
       * (Optional) The amount of time in seconds to wait for a command to deliver to the AWS Systems Manager SSM Agent on an instance. If the command isn't received by the SSM Agent on the instance before the value specified is reached, then the status of the command changes to Delivery Timed Out.
       */
    readonly commandTimeoutSeconds?: INumberVariable;
    /**
       * (Optional) The maximum concurrency.
       */
    readonly maxConcurrency?: INumberVariable;
    /**
       * (Optional) The maximum errors.
       */
    readonly maxErrors?: INumberVariable;
}
/**
 * AutomationStep implementation of [aws:runCommand](https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-runcommand.html)
 */
export declare class RunCommandStep extends AutomationStep {
    readonly action = "aws:runCommand";
    readonly documentName: IStringVariable;
    readonly targets: IStringListVariable | IMapListVariable;
    readonly parameters?: IStringMapVariable;
    readonly cloudWatchOutputConfig?: IStringMapVariable;
    readonly comment?: IStringVariable;
    readonly documentHash?: IStringVariable;
    readonly documentHashType?: IDocumentHashTypeVariable;
    readonly notificationConfig?: IStringMapVariable;
    readonly outputS3BucketName?: IStringVariable;
    readonly outputS3KeyPrefix?: IStringVariable;
    readonly serviceRoleArn?: IStringVariable;
    readonly commandTimeoutSeconds?: INumberVariable;
    readonly maxConcurrency?: INumberVariable;
    readonly maxErrors?: INumberVariable;
    constructor(scope: Construct, id: string, props: RunCommandStepProps);
    listOutputs(): Output[];
    listInputs(): string[];
    toSsmEntry(): Record<string, any>;
}
