"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WaitForAndAssertResource = void 0;
const assert_aws_resource_step_1 = require("../../parent-steps/automation/assert-aws-resource-step");
const wait_for_resource_step_1 = require("../../parent-steps/automation/wait-for-resource-step");
const composite_step_1 = require("./composite-step");
/**
 * Waits for resource value and asserts that the value is one of the desired values.
 */
class WaitForAndAssertResource extends composite_step_1.CompositeAutomationStep {
    constructor(scope, id, props) {
        super(scope, id);
        const stepParams = {
            service: props.service,
            pascalCaseApi: props.pascalCaseApi,
            apiParams: props.apiParams,
            selector: props.selector,
        };
        this.waitForValues = new wait_for_resource_step_1.WaitForResourceStep(this, 'waitForValues', {
            ...stepParams,
            desiredValues: props.waitForValues,
        });
        this.assertDesired = new assert_aws_resource_step_1.AssertAwsResourceStep(this, 'assertDesired', {
            ...stepParams,
            desiredValues: props.desiredValues,
        });
    }
    addToDocument(doc) {
        doc.addStep(this.waitForValues);
        doc.addStep(this.assertDesired);
    }
}
exports.WaitForAndAssertResource = WaitForAndAssertResource;
//# sourceMappingURL=data:application/json;base64,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