"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HelloWorld = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const automation_document_1 = require("../document/automation-document");
const data_type_1 = require("../domain/data-type");
const input_1 = require("../domain/input");
const string_variable_1 = require("../interface/variables/string-variable");
const aws_api_step_1 = require("../parent-steps/automation/aws-api-step");
const execute_script_step_1 = require("../parent-steps/automation/execute-script-step");
const aws_service_1 = require("../domain/aws-service");
class HelloWorld extends aws_cdk_lib_1.Stack {
    constructor(app, id) {
        super(app, id);
        const doc = new automation_document_1.AutomationDocument(this, 'HelloWorld', {
            docInputs: [
                input_1.Input.ofTypeString('Someone', { allowedPattern: '[a-zA-Z]+' }),
                input_1.Input.ofTypeString('SnsTopic'),
            ],
        });
        const greeting = new execute_script_step_1.ExecuteScriptStep(this, 'PrependWithGreeting', {
            language: execute_script_step_1.ScriptLanguage.python(execute_script_step_1.PythonVersion.VERSION_3_6, 'my_func'),
            code: execute_script_step_1.ScriptCode.inline('def my_func(args, context):\n' +
                '    return {"Greeting": "Hello " + args["someone"]}\n' +
                '\n'),
            inputPayload: { someone: string_variable_1.StringVariable.of('Someone') },
            outputs: [{
                    outputType: data_type_1.DataTypeEnum.STRING,
                    name: 'Greeting',
                    selector: '$.Payload.Greeting',
                }],
        });
        doc.addStep(greeting);
        doc.addStep(new aws_api_step_1.AwsApiStep(this, 'PublishToSns', {
            outputs: [],
            service: aws_service_1.AwsService.SNS,
            pascalCaseApi: 'publish',
            apiParams: {
                TargetArn: new string_variable_1.StringVariable('SnsTopic'),
                Message: greeting.variables().Greeting,
            },
        }));
    }
}
exports.HelloWorld = HelloWorld;
_a = JSII_RTTI_SYMBOL_1;
HelloWorld[_a] = { fqn: "@cdklabs/cdk-ssm-documents.HelloWorld", version: "0.0.31" };
//# sourceMappingURL=data:application/json;base64,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