import { IAwsInvoker } from '../../interface/aws-invoker';
import { ISleepHook } from '../../interface/sleep-hook';
import { CreateTagsStep } from '../../parent-steps/automation/create-tags-step';
import { AutomationSimulationBase } from './automation-simulation-base';
/**
 * Properties for CreateTagStep
 */
export interface CreateTagsSimulationProps {
    /**
       * (Optional) Use this as a hook to inject an alternate IAwsInvoker (for mocking the AWS API call).
       * @default - will perform a real invocation of the JavaScript AWS SDK using ReflectiveAwsInvoker class.
       */
    readonly awsInvoker: IAwsInvoker;
    /**
       * (Optional) Whether to really perform a pause of the runtime.
       * To override sleep behavior, inject an ISleepHook impl or use the provided MockSleep class.
       * @default SleeperImpl
       */
    readonly sleepHook: ISleepHook;
}
/**
 * AutomationStep implemenation for aws:createTags
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-createtag.html
 */
export declare class CreateTagsSimulation extends AutomationSimulationBase {
    readonly action = "aws:createTags";
    private createTagsStep;
    private props;
    constructor(step: CreateTagsStep, props: CreateTagsSimulationProps);
    executeStep(inputs: Record<string, any>): Record<string, any>;
    private createEc2Tags;
    private callEc2CreateTags;
    private waitForEc2Tags;
    private areEc2TagsAssociatedToTheResources;
    private buildEc2TagFilter;
    private ec2DescribeTags;
    private createSsmTags;
    private callSsmAddTagsToResource;
    private waitForSsmTags;
    private areAllSsmTagsListed;
    private ssmListTagsForResource;
    private getSingleResourceId;
}
