import { ExecuteStateMachineStep } from '../../parent-steps/automation/execute-state-machine-step';
import { AutomationSimulationBase } from './automation-simulation-base';
import { AwsInvocationSimulationProps } from './aws-api-simulation';
/**
 * AutomationStep implementation of [aws:executeStateMachine](https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-executeStateMachine.html)
 */
export declare class ExecuteStateMachineSimulation extends AutomationSimulationBase {
    readonly action: string;
    readonly executeStateMachineStep: ExecuteStateMachineStep;
    readonly props: AwsInvocationSimulationProps;
    constructor(step: ExecuteStateMachineStep, props: AwsInvocationSimulationProps);
    executeStep(inputs: Record<string, any>): Record<string, any>;
    private startExecution;
    private waitForExecution;
}
