# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetEndpointsResult',
    'AwaitableGetEndpointsResult',
    'get_endpoints',
    'get_endpoints_output',
]

@pulumi.output_type
class GetEndpointsResult:
    """
    A collection of values returned by getEndpoints.
    """
    def __init__(__self__, compartment_id=None, display_name=None, endpoint_collections=None, filters=None, id=None, model_id=None, project_id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if endpoint_collections and not isinstance(endpoint_collections, list):
            raise TypeError("Expected argument 'endpoint_collections' to be a list")
        pulumi.set(__self__, "endpoint_collections", endpoint_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if model_id and not isinstance(model_id, str):
            raise TypeError("Expected argument 'model_id' to be a str")
        pulumi.set(__self__, "model_id", model_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the endpoint compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly display name for the resource. It should be unique and can be modified. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="endpointCollections")
    def endpoint_collections(self) -> Sequence['outputs.GetEndpointsEndpointCollectionResult']:
        """
        The list of endpoint_collection.
        """
        return pulumi.get(self, "endpoint_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetEndpointsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Unique identifier endpoint OCID of an endpoint that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model to associate with the endpoint.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project to associate with the Endpoint.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The state of the endpoint.
        """
        return pulumi.get(self, "state")


class AwaitableGetEndpointsResult(GetEndpointsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEndpointsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            endpoint_collections=self.endpoint_collections,
            filters=self.filters,
            id=self.id,
            model_id=self.model_id,
            project_id=self.project_id,
            state=self.state)


def get_endpoints(compartment_id: Optional[builtins.str] = None,
                  display_name: Optional[builtins.str] = None,
                  filters: Optional[Sequence[Union['GetEndpointsFilterArgs', 'GetEndpointsFilterArgsDict']]] = None,
                  id: Optional[builtins.str] = None,
                  model_id: Optional[builtins.str] = None,
                  project_id: Optional[builtins.str] = None,
                  state: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEndpointsResult:
    """
    This data source provides the list of Endpoints in Oracle Cloud Infrastructure Ai Language service.

    Returns a list of Endpoints.


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str id: Unique identifier endpoint OCID of an endpoint that is immutable on creation.
    :param builtins.str model_id: The ID of the trained model for which to list the endpoints.
    :param builtins.str project_id: The ID of the project for which to list the objects.
    :param builtins.str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['modelId'] = model_id
    __args__['projectId'] = project_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:AiLanguage/getEndpoints:getEndpoints', __args__, opts=opts, typ=GetEndpointsResult).value

    return AwaitableGetEndpointsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        endpoint_collections=pulumi.get(__ret__, 'endpoint_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        model_id=pulumi.get(__ret__, 'model_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        state=pulumi.get(__ret__, 'state'))
def get_endpoints_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                         display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetEndpointsFilterArgs', 'GetEndpointsFilterArgsDict']]]]] = None,
                         id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         model_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         project_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEndpointsResult]:
    """
    This data source provides the list of Endpoints in Oracle Cloud Infrastructure Ai Language service.

    Returns a list of Endpoints.


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param builtins.str id: Unique identifier endpoint OCID of an endpoint that is immutable on creation.
    :param builtins.str model_id: The ID of the trained model for which to list the endpoints.
    :param builtins.str project_id: The ID of the project for which to list the objects.
    :param builtins.str state: <b>Filter</b> results by the specified lifecycle state. Must be a valid state for the resource type.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['modelId'] = model_id
    __args__['projectId'] = project_id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:AiLanguage/getEndpoints:getEndpoints', __args__, opts=opts, typ=GetEndpointsResult)
    return __ret__.apply(lambda __response__: GetEndpointsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        endpoint_collections=pulumi.get(__response__, 'endpoint_collections'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        model_id=pulumi.get(__response__, 'model_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        state=pulumi.get(__response__, 'state')))
