# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBastionsResult',
    'AwaitableGetBastionsResult',
    'get_bastions',
    'get_bastions_output',
]

@pulumi.output_type
class GetBastionsResult:
    """
    A collection of values returned by getBastions.
    """
    def __init__(__self__, bastion_id=None, bastion_lifecycle_state=None, bastions=None, compartment_id=None, filters=None, id=None, name=None):
        if bastion_id and not isinstance(bastion_id, str):
            raise TypeError("Expected argument 'bastion_id' to be a str")
        pulumi.set(__self__, "bastion_id", bastion_id)
        if bastion_lifecycle_state and not isinstance(bastion_lifecycle_state, str):
            raise TypeError("Expected argument 'bastion_lifecycle_state' to be a str")
        pulumi.set(__self__, "bastion_lifecycle_state", bastion_lifecycle_state)
        if bastions and not isinstance(bastions, list):
            raise TypeError("Expected argument 'bastions' to be a list")
        pulumi.set(__self__, "bastions", bastions)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="bastionId")
    def bastion_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "bastion_id")

    @property
    @pulumi.getter(name="bastionLifecycleState")
    def bastion_lifecycle_state(self) -> Optional[builtins.str]:
        return pulumi.get(self, "bastion_lifecycle_state")

    @property
    @pulumi.getter
    def bastions(self) -> Sequence['outputs.GetBastionsBastionResult']:
        """
        The list of bastions.
        """
        return pulumi.get(self, "bastions")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The unique identifier (OCID) of the compartment where the bastion is located.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetBastionsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the bastion, which can't be changed after creation.
        """
        return pulumi.get(self, "name")


class AwaitableGetBastionsResult(GetBastionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBastionsResult(
            bastion_id=self.bastion_id,
            bastion_lifecycle_state=self.bastion_lifecycle_state,
            bastions=self.bastions,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name)


def get_bastions(bastion_id: Optional[builtins.str] = None,
                 bastion_lifecycle_state: Optional[builtins.str] = None,
                 compartment_id: Optional[builtins.str] = None,
                 filters: Optional[Sequence[Union['GetBastionsFilterArgs', 'GetBastionsFilterArgsDict']]] = None,
                 name: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBastionsResult:
    """
    This data source provides the list of Bastions in Oracle Cloud Infrastructure Bastion service.

    Retrieves a list of BastionSummary objects in a compartment. Bastions provide secured, public access to target resources in the cloud that you cannot otherwise reach from the internet.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bastions = oci.Bastion.get_bastions(compartment_id=compartment_id,
        bastion_id=test_bastion["id"],
        bastion_lifecycle_state=bastion_bastion_lifecycle_state,
        name=bastion_name)
    ```


    :param builtins.str bastion_id: The unique identifier (OCID) of the bastion in which to list resources.
    :param builtins.str bastion_lifecycle_state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    :param builtins.str compartment_id: The unique identifier (OCID) of the compartment in which to list resources.
    :param builtins.str name: A filter to return only resources that match the entire name given.
    """
    __args__ = dict()
    __args__['bastionId'] = bastion_id
    __args__['bastionLifecycleState'] = bastion_lifecycle_state
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Bastion/getBastions:getBastions', __args__, opts=opts, typ=GetBastionsResult).value

    return AwaitableGetBastionsResult(
        bastion_id=pulumi.get(__ret__, 'bastion_id'),
        bastion_lifecycle_state=pulumi.get(__ret__, 'bastion_lifecycle_state'),
        bastions=pulumi.get(__ret__, 'bastions'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))
def get_bastions_output(bastion_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        bastion_lifecycle_state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetBastionsFilterArgs', 'GetBastionsFilterArgsDict']]]]] = None,
                        name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBastionsResult]:
    """
    This data source provides the list of Bastions in Oracle Cloud Infrastructure Bastion service.

    Retrieves a list of BastionSummary objects in a compartment. Bastions provide secured, public access to target resources in the cloud that you cannot otherwise reach from the internet.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bastions = oci.Bastion.get_bastions(compartment_id=compartment_id,
        bastion_id=test_bastion["id"],
        bastion_lifecycle_state=bastion_bastion_lifecycle_state,
        name=bastion_name)
    ```


    :param builtins.str bastion_id: The unique identifier (OCID) of the bastion in which to list resources.
    :param builtins.str bastion_lifecycle_state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    :param builtins.str compartment_id: The unique identifier (OCID) of the compartment in which to list resources.
    :param builtins.str name: A filter to return only resources that match the entire name given.
    """
    __args__ = dict()
    __args__['bastionId'] = bastion_id
    __args__['bastionLifecycleState'] = bastion_lifecycle_state
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Bastion/getBastions:getBastions', __args__, opts=opts, typ=GetBastionsResult)
    return __ret__.apply(lambda __response__: GetBastionsResult(
        bastion_id=pulumi.get(__response__, 'bastion_id'),
        bastion_lifecycle_state=pulumi.get(__response__, 'bastion_lifecycle_state'),
        bastions=pulumi.get(__response__, 'bastions'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name')))
