# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAlertRulesAlertRuleResult',
    'GetAlertRulesFilterResult',
    'GetBudgetsBudgetResult',
    'GetBudgetsFilterResult',
]

@pulumi.output_type
class GetAlertRulesAlertRuleResult(dict):
    def __init__(__self__, *,
                 budget_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 message: builtins.str,
                 recipients: builtins.str,
                 state: builtins.str,
                 threshold: builtins.float,
                 threshold_type: builtins.str,
                 time_created: builtins.str,
                 time_updated: builtins.str,
                 type: builtins.str,
                 version: builtins.int):
        """
        :param builtins.str budget_id: The unique budget OCID.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str description: The description of the alert rule.
        :param builtins.str display_name: A user-friendly name. This does not have to be unique, and it's changeable.  Example: `My new resource`
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param builtins.str id: The OCID of the alert rule.
        :param builtins.str message: The custom message that will be sent when the alert is triggered.
        :param builtins.str recipients: The delimited list of email addresses to receive the alert when it triggers. Delimiter characters can be a comma, space, TAB, or semicolon.
        :param builtins.str state: The current state of the resource to filter by.
        :param builtins.float threshold: The threshold for triggering the alert. If the thresholdType is PERCENTAGE, the maximum value is 10000.
        :param builtins.str threshold_type: The type of threshold.
        :param builtins.str time_created: The time when the budget was created.
        :param builtins.str time_updated: The time when the budget was updated.
        :param builtins.str type: The type of the alert. Valid values are ACTUAL (the alert triggers based on actual usage), or FORECAST (the alert triggers based on predicted usage).
        :param builtins.int version: The version of the alert rule. Starts from 1 and increments by 1.
        """
        pulumi.set(__self__, "budget_id", budget_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "recipients", recipients)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "threshold_type", threshold_type)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="budgetId")
    def budget_id(self) -> builtins.str:
        """
        The unique budget OCID.
        """
        return pulumi.get(self, "budget_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the alert rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. This does not have to be unique, and it's changeable.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the alert rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def message(self) -> builtins.str:
        """
        The custom message that will be sent when the alert is triggered.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def recipients(self) -> builtins.str:
        """
        The delimited list of email addresses to receive the alert when it triggers. Delimiter characters can be a comma, space, TAB, or semicolon.
        """
        return pulumi.get(self, "recipients")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the resource to filter by.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def threshold(self) -> builtins.float:
        """
        The threshold for triggering the alert. If the thresholdType is PERCENTAGE, the maximum value is 10000.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="thresholdType")
    def threshold_type(self) -> builtins.str:
        """
        The type of threshold.
        """
        return pulumi.get(self, "threshold_type")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time when the budget was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time when the budget was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of the alert. Valid values are ACTUAL (the alert triggers based on actual usage), or FORECAST (the alert triggers based on predicted usage).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> builtins.int:
        """
        The version of the alert rule. Starts from 1 and increments by 1.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetAlertRulesFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetBudgetsBudgetResult(dict):
    def __init__(__self__, *,
                 actual_spend: builtins.float,
                 alert_rule_count: builtins.int,
                 amount: builtins.int,
                 budget_processing_period_start_offset: builtins.int,
                 compartment_id: builtins.str,
                 defined_tags: Mapping[str, builtins.str],
                 description: builtins.str,
                 display_name: builtins.str,
                 end_date: builtins.str,
                 forecasted_spend: builtins.float,
                 freeform_tags: Mapping[str, builtins.str],
                 id: builtins.str,
                 processing_period_type: builtins.str,
                 reset_period: builtins.str,
                 start_date: builtins.str,
                 state: builtins.str,
                 target_compartment_id: builtins.str,
                 target_type: builtins.str,
                 targets: Sequence[builtins.str],
                 time_created: builtins.str,
                 time_spend_computed: builtins.str,
                 time_updated: builtins.str,
                 version: builtins.int):
        """
        :param builtins.float actual_spend: The actual spend in currency for the current budget cycle.
        :param builtins.int alert_rule_count: The total number of alert rules in the budget.
        :param builtins.int amount: The amount of the budget, expressed in the currency of the customer's rate card.
        :param builtins.int budget_processing_period_start_offset: The number of days offset from the first day of the month, at which the budget processing period starts. In months that have fewer days than this value, processing will begin on the last day of that month. For example, for a value of 12, processing starts every month on the 12th at midnight.
        :param builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param Mapping[str, builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param builtins.str description: The description of the budget.
        :param builtins.str display_name: A user-friendly name. This does not have to be unique, and it's changeable.  Example: `My new resource`
        :param builtins.str end_date: The time when the one-time budget concludes. For example, - `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        :param builtins.float forecasted_spend: The forecasted spend in currency by the end of the current budget cycle.
        :param Mapping[str, builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param builtins.str id: The OCID of the budget.
        :param builtins.str processing_period_type: The type of the budget processing period. Valid values are INVOICE, MONTH, and SINGLE_USE.
        :param builtins.str reset_period: The reset period for the budget.
        :param builtins.str start_date: The date when the one-time budget begins. For example, `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        :param builtins.str state: The current state of the resource to filter by.
        :param builtins.str target_compartment_id: This is DEPRECATED. For backwards compatability, the property is populated when the targetType is "COMPARTMENT", and targets contain the specific target compartment OCID. For all other scenarios, this property will be left empty.
        :param builtins.str target_type: The type of target to filter by:
               * ALL - List all budgets
               * COMPARTMENT - List all budgets with targetType == "COMPARTMENT"
               * TAG - List all budgets with targetType == "TAG"
        :param Sequence[builtins.str] targets: The list of targets on which the budget is applied. If the targetType is "COMPARTMENT", the targets contain the list of compartment OCIDs. If the targetType is "TAG", the targets contain the list of cost tracking tag identifiers in the form of "{tagNamespace}.{tagKey}.{tagValue}".
        :param builtins.str time_created: The time that the budget was created.
        :param builtins.str time_spend_computed: The time that the budget spend was last computed.
        :param builtins.str time_updated: The time that the budget was updated.
        :param builtins.int version: The version of the budget. Starts from 1 and increments by 1.
        """
        pulumi.set(__self__, "actual_spend", actual_spend)
        pulumi.set(__self__, "alert_rule_count", alert_rule_count)
        pulumi.set(__self__, "amount", amount)
        pulumi.set(__self__, "budget_processing_period_start_offset", budget_processing_period_start_offset)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "forecasted_spend", forecasted_spend)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "processing_period_type", processing_period_type)
        pulumi.set(__self__, "reset_period", reset_period)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "target_compartment_id", target_compartment_id)
        pulumi.set(__self__, "target_type", target_type)
        pulumi.set(__self__, "targets", targets)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_spend_computed", time_spend_computed)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="actualSpend")
    def actual_spend(self) -> builtins.float:
        """
        The actual spend in currency for the current budget cycle.
        """
        return pulumi.get(self, "actual_spend")

    @property
    @pulumi.getter(name="alertRuleCount")
    def alert_rule_count(self) -> builtins.int:
        """
        The total number of alert rules in the budget.
        """
        return pulumi.get(self, "alert_rule_count")

    @property
    @pulumi.getter
    def amount(self) -> builtins.int:
        """
        The amount of the budget, expressed in the currency of the customer's rate card.
        """
        return pulumi.get(self, "amount")

    @property
    @pulumi.getter(name="budgetProcessingPeriodStartOffset")
    def budget_processing_period_start_offset(self) -> builtins.int:
        """
        The number of days offset from the first day of the month, at which the budget processing period starts. In months that have fewer days than this value, processing will begin on the last day of that month. For example, for a value of 12, processing starts every month on the 12th at midnight.
        """
        return pulumi.get(self, "budget_processing_period_start_offset")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the budget.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. This does not have to be unique, and it's changeable.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> builtins.str:
        """
        The time when the one-time budget concludes. For example, - `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="forecastedSpend")
    def forecasted_spend(self) -> builtins.float:
        """
        The forecasted spend in currency by the end of the current budget cycle.
        """
        return pulumi.get(self, "forecasted_spend")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the budget.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="processingPeriodType")
    def processing_period_type(self) -> builtins.str:
        """
        The type of the budget processing period. Valid values are INVOICE, MONTH, and SINGLE_USE.
        """
        return pulumi.get(self, "processing_period_type")

    @property
    @pulumi.getter(name="resetPeriod")
    def reset_period(self) -> builtins.str:
        """
        The reset period for the budget.
        """
        return pulumi.get(self, "reset_period")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> builtins.str:
        """
        The date when the one-time budget begins. For example, `2023-03-23`. The date-time format conforms to RFC 3339, and will be truncated to the starting point of the date provided after being converted to UTC time.
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the resource to filter by.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetCompartmentId")
    @_utilities.deprecated("""The 'target_compartment_id' field has been deprecated. Please use 'targets' instead.""")
    def target_compartment_id(self) -> builtins.str:
        """
        This is DEPRECATED. For backwards compatability, the property is populated when the targetType is "COMPARTMENT", and targets contain the specific target compartment OCID. For all other scenarios, this property will be left empty.
        """
        return pulumi.get(self, "target_compartment_id")

    @property
    @pulumi.getter(name="targetType")
    def target_type(self) -> builtins.str:
        """
        The type of target to filter by:
        * ALL - List all budgets
        * COMPARTMENT - List all budgets with targetType == "COMPARTMENT"
        * TAG - List all budgets with targetType == "TAG"
        """
        return pulumi.get(self, "target_type")

    @property
    @pulumi.getter
    def targets(self) -> Sequence[builtins.str]:
        """
        The list of targets on which the budget is applied. If the targetType is "COMPARTMENT", the targets contain the list of compartment OCIDs. If the targetType is "TAG", the targets contain the list of cost tracking tag identifiers in the form of "{tagNamespace}.{tagKey}.{tagValue}".
        """
        return pulumi.get(self, "targets")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time that the budget was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeSpendComputed")
    def time_spend_computed(self) -> builtins.str:
        """
        The time that the budget spend was last computed.
        """
        return pulumi.get(self, "time_spend_computed")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time that the budget was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def version(self) -> builtins.int:
        """
        The version of the budget. Starts from 1 and increments by 1.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetBudgetsFilterResult(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 values: Sequence[builtins.str],
                 regex: Optional[builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "regex")


