# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInternalOccmDemandSignalCatalogResourcesResult',
    'AwaitableGetInternalOccmDemandSignalCatalogResourcesResult',
    'get_internal_occm_demand_signal_catalog_resources',
    'get_internal_occm_demand_signal_catalog_resources_output',
]

@pulumi.output_type
class GetInternalOccmDemandSignalCatalogResourcesResult:
    """
    A collection of values returned by getInternalOccmDemandSignalCatalogResources.
    """
    def __init__(__self__, compartment_id=None, demand_signal_namespace=None, filters=None, id=None, internal_occm_demand_signal_catalog_resource_collections=None, name=None, occ_customer_group_id=None, occm_demand_signal_catalog_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if demand_signal_namespace and not isinstance(demand_signal_namespace, str):
            raise TypeError("Expected argument 'demand_signal_namespace' to be a str")
        pulumi.set(__self__, "demand_signal_namespace", demand_signal_namespace)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if internal_occm_demand_signal_catalog_resource_collections and not isinstance(internal_occm_demand_signal_catalog_resource_collections, list):
            raise TypeError("Expected argument 'internal_occm_demand_signal_catalog_resource_collections' to be a list")
        pulumi.set(__self__, "internal_occm_demand_signal_catalog_resource_collections", internal_occm_demand_signal_catalog_resource_collections)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if occ_customer_group_id and not isinstance(occ_customer_group_id, str):
            raise TypeError("Expected argument 'occ_customer_group_id' to be a str")
        pulumi.set(__self__, "occ_customer_group_id", occ_customer_group_id)
        if occm_demand_signal_catalog_id and not isinstance(occm_demand_signal_catalog_id, str):
            raise TypeError("Expected argument 'occm_demand_signal_catalog_id' to be a str")
        pulumi.set(__self__, "occm_demand_signal_catalog_id", occm_demand_signal_catalog_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the tenancy from which the request to create the demand signal catalog was made.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="demandSignalNamespace")
    def demand_signal_namespace(self) -> Optional[builtins.str]:
        return pulumi.get(self, "demand_signal_namespace")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInternalOccmDemandSignalCatalogResourcesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="internalOccmDemandSignalCatalogResourceCollections")
    def internal_occm_demand_signal_catalog_resource_collections(self) -> Sequence['outputs.GetInternalOccmDemandSignalCatalogResourcesInternalOccmDemandSignalCatalogResourceCollectionResult']:
        """
        The list of internal_occm_demand_signal_catalog_resource_collection.
        """
        return pulumi.get(self, "internal_occm_demand_signal_catalog_resource_collections")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the Oracle Cloud Infrastructure resource that you want to request.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="occCustomerGroupId")
    def occ_customer_group_id(self) -> builtins.str:
        """
        The OCID of the customerGroup.
        """
        return pulumi.get(self, "occ_customer_group_id")

    @property
    @pulumi.getter(name="occmDemandSignalCatalogId")
    def occm_demand_signal_catalog_id(self) -> builtins.str:
        """
        This OCID of the demand signal catalog
        """
        return pulumi.get(self, "occm_demand_signal_catalog_id")


class AwaitableGetInternalOccmDemandSignalCatalogResourcesResult(GetInternalOccmDemandSignalCatalogResourcesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInternalOccmDemandSignalCatalogResourcesResult(
            compartment_id=self.compartment_id,
            demand_signal_namespace=self.demand_signal_namespace,
            filters=self.filters,
            id=self.id,
            internal_occm_demand_signal_catalog_resource_collections=self.internal_occm_demand_signal_catalog_resource_collections,
            name=self.name,
            occ_customer_group_id=self.occ_customer_group_id,
            occm_demand_signal_catalog_id=self.occm_demand_signal_catalog_id)


def get_internal_occm_demand_signal_catalog_resources(compartment_id: Optional[builtins.str] = None,
                                                      demand_signal_namespace: Optional[builtins.str] = None,
                                                      filters: Optional[Sequence[Union['GetInternalOccmDemandSignalCatalogResourcesFilterArgs', 'GetInternalOccmDemandSignalCatalogResourcesFilterArgsDict']]] = None,
                                                      name: Optional[builtins.str] = None,
                                                      occ_customer_group_id: Optional[builtins.str] = None,
                                                      occm_demand_signal_catalog_id: Optional[builtins.str] = None,
                                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInternalOccmDemandSignalCatalogResourcesResult:
    """
    This data source provides the list of Internal Occm Demand Signal Catalog Resources in Oracle Cloud Infrastructure Capacity Management service.

    This API will list all the  resources across all demand signal catalogs for a given namespace and customer group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_internal_occm_demand_signal_catalog_resources = oci.CapacityManagement.get_internal_occm_demand_signal_catalog_resources(compartment_id=compartment_id,
        occ_customer_group_id=test_occ_customer_group["id"],
        occm_demand_signal_catalog_id=test_catalog["id"],
        demand_signal_namespace=internal_occm_demand_signal_catalog_resource_demand_signal_namespace,
        name=internal_occm_demand_signal_catalog_resource_name)
    ```


    :param builtins.str compartment_id: The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.
    :param builtins.str demand_signal_namespace: A query parameter to filter the list of demand signal catalog resources based on the namespace.
    :param builtins.str name: A query parameter to filter the list of demand signal catalog resource based on the resource name.
    :param builtins.str occ_customer_group_id: The customer group ocid by which we would filter the list.
    :param builtins.str occm_demand_signal_catalog_id: The ocid of demand signal catalog id.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['demandSignalNamespace'] = demand_signal_namespace
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['occCustomerGroupId'] = occ_customer_group_id
    __args__['occmDemandSignalCatalogId'] = occm_demand_signal_catalog_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CapacityManagement/getInternalOccmDemandSignalCatalogResources:getInternalOccmDemandSignalCatalogResources', __args__, opts=opts, typ=GetInternalOccmDemandSignalCatalogResourcesResult).value

    return AwaitableGetInternalOccmDemandSignalCatalogResourcesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        demand_signal_namespace=pulumi.get(__ret__, 'demand_signal_namespace'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        internal_occm_demand_signal_catalog_resource_collections=pulumi.get(__ret__, 'internal_occm_demand_signal_catalog_resource_collections'),
        name=pulumi.get(__ret__, 'name'),
        occ_customer_group_id=pulumi.get(__ret__, 'occ_customer_group_id'),
        occm_demand_signal_catalog_id=pulumi.get(__ret__, 'occm_demand_signal_catalog_id'))
def get_internal_occm_demand_signal_catalog_resources_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                                             demand_signal_namespace: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetInternalOccmDemandSignalCatalogResourcesFilterArgs', 'GetInternalOccmDemandSignalCatalogResourcesFilterArgsDict']]]]] = None,
                                                             name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                             occ_customer_group_id: Optional[pulumi.Input[builtins.str]] = None,
                                                             occm_demand_signal_catalog_id: Optional[pulumi.Input[builtins.str]] = None,
                                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInternalOccmDemandSignalCatalogResourcesResult]:
    """
    This data source provides the list of Internal Occm Demand Signal Catalog Resources in Oracle Cloud Infrastructure Capacity Management service.

    This API will list all the  resources across all demand signal catalogs for a given namespace and customer group.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_internal_occm_demand_signal_catalog_resources = oci.CapacityManagement.get_internal_occm_demand_signal_catalog_resources(compartment_id=compartment_id,
        occ_customer_group_id=test_occ_customer_group["id"],
        occm_demand_signal_catalog_id=test_catalog["id"],
        demand_signal_namespace=internal_occm_demand_signal_catalog_resource_demand_signal_namespace,
        name=internal_occm_demand_signal_catalog_resource_name)
    ```


    :param builtins.str compartment_id: The ocid of the compartment or tenancy in which resources are to be listed. This will also be used for authorization purposes.
    :param builtins.str demand_signal_namespace: A query parameter to filter the list of demand signal catalog resources based on the namespace.
    :param builtins.str name: A query parameter to filter the list of demand signal catalog resource based on the resource name.
    :param builtins.str occ_customer_group_id: The customer group ocid by which we would filter the list.
    :param builtins.str occm_demand_signal_catalog_id: The ocid of demand signal catalog id.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['demandSignalNamespace'] = demand_signal_namespace
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['occCustomerGroupId'] = occ_customer_group_id
    __args__['occmDemandSignalCatalogId'] = occm_demand_signal_catalog_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CapacityManagement/getInternalOccmDemandSignalCatalogResources:getInternalOccmDemandSignalCatalogResources', __args__, opts=opts, typ=GetInternalOccmDemandSignalCatalogResourcesResult)
    return __ret__.apply(lambda __response__: GetInternalOccmDemandSignalCatalogResourcesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        demand_signal_namespace=pulumi.get(__response__, 'demand_signal_namespace'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        internal_occm_demand_signal_catalog_resource_collections=pulumi.get(__response__, 'internal_occm_demand_signal_catalog_resource_collections'),
        name=pulumi.get(__response__, 'name'),
        occ_customer_group_id=pulumi.get(__response__, 'occ_customer_group_id'),
        occm_demand_signal_catalog_id=pulumi.get(__response__, 'occm_demand_signal_catalog_id')))
