# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetOccmDemandSignalItemResult',
    'AwaitableGetOccmDemandSignalItemResult',
    'get_occm_demand_signal_item',
    'get_occm_demand_signal_item_output',
]

@pulumi.output_type
class GetOccmDemandSignalItemResult:
    """
    A collection of values returned by getOccmDemandSignalItem.
    """
    def __init__(__self__, availability_domain=None, compartment_id=None, defined_tags=None, demand_quantity=None, demand_signal_catalog_resource_id=None, demand_signal_id=None, demand_signal_namespace=None, freeform_tags=None, id=None, notes=None, occm_demand_signal_item_id=None, region=None, request_type=None, resource_name=None, resource_properties=None, state=None, system_tags=None, target_compartment_id=None, time_needed_before=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if demand_quantity and not isinstance(demand_quantity, str):
            raise TypeError("Expected argument 'demand_quantity' to be a str")
        pulumi.set(__self__, "demand_quantity", demand_quantity)
        if demand_signal_catalog_resource_id and not isinstance(demand_signal_catalog_resource_id, str):
            raise TypeError("Expected argument 'demand_signal_catalog_resource_id' to be a str")
        pulumi.set(__self__, "demand_signal_catalog_resource_id", demand_signal_catalog_resource_id)
        if demand_signal_id and not isinstance(demand_signal_id, str):
            raise TypeError("Expected argument 'demand_signal_id' to be a str")
        pulumi.set(__self__, "demand_signal_id", demand_signal_id)
        if demand_signal_namespace and not isinstance(demand_signal_namespace, str):
            raise TypeError("Expected argument 'demand_signal_namespace' to be a str")
        pulumi.set(__self__, "demand_signal_namespace", demand_signal_namespace)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if notes and not isinstance(notes, str):
            raise TypeError("Expected argument 'notes' to be a str")
        pulumi.set(__self__, "notes", notes)
        if occm_demand_signal_item_id and not isinstance(occm_demand_signal_item_id, str):
            raise TypeError("Expected argument 'occm_demand_signal_item_id' to be a str")
        pulumi.set(__self__, "occm_demand_signal_item_id", occm_demand_signal_item_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if request_type and not isinstance(request_type, str):
            raise TypeError("Expected argument 'request_type' to be a str")
        pulumi.set(__self__, "request_type", request_type)
        if resource_name and not isinstance(resource_name, str):
            raise TypeError("Expected argument 'resource_name' to be a str")
        pulumi.set(__self__, "resource_name", resource_name)
        if resource_properties and not isinstance(resource_properties, dict):
            raise TypeError("Expected argument 'resource_properties' to be a dict")
        pulumi.set(__self__, "resource_properties", resource_properties)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if target_compartment_id and not isinstance(target_compartment_id, str):
            raise TypeError("Expected argument 'target_compartment_id' to be a str")
        pulumi.set(__self__, "target_compartment_id", target_compartment_id)
        if time_needed_before and not isinstance(time_needed_before, str):
            raise TypeError("Expected argument 'time_needed_before' to be a str")
        pulumi.set(__self__, "time_needed_before", time_needed_before)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> builtins.str:
        """
        The name of the availability domain for which you want to request the Oracle Cloud Infrastructure resource.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the tenancy from which the demand signal item was created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="demandQuantity")
    def demand_quantity(self) -> builtins.str:
        """
        The quantity of the resource that you want to demand from OCI.
        """
        return pulumi.get(self, "demand_quantity")

    @property
    @pulumi.getter(name="demandSignalCatalogResourceId")
    def demand_signal_catalog_resource_id(self) -> builtins.str:
        """
        The OCID of the corresponding demand signal catalog resource.
        """
        return pulumi.get(self, "demand_signal_catalog_resource_id")

    @property
    @pulumi.getter(name="demandSignalId")
    def demand_signal_id(self) -> builtins.str:
        """
        The OCID of the demand signal under which this item will be grouped.
        """
        return pulumi.get(self, "demand_signal_id")

    @property
    @pulumi.getter(name="demandSignalNamespace")
    def demand_signal_namespace(self) -> builtins.str:
        """
        The name of the Oracle Cloud Infrastructure service in consideration for demand signal submission. For example: COMPUTE, NETWORK, GPU etc.
        """
        return pulumi.get(self, "demand_signal_namespace")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the demand signal item.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def notes(self) -> builtins.str:
        """
        This field will serve as notes section for you. You can use this section to convey a message to Oracle Cloud Infrastructure regarding your resource request.
        """
        return pulumi.get(self, "notes")

    @property
    @pulumi.getter(name="occmDemandSignalItemId")
    def occm_demand_signal_item_id(self) -> builtins.str:
        return pulumi.get(self, "occm_demand_signal_item_id")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        The name of region for which you want to request the Oracle Cloud Infrastructure resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="requestType")
    def request_type(self) -> builtins.str:
        """
        The type of request (DEMAND or RETURN) made against a particular demand signal item.
        """
        return pulumi.get(self, "request_type")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> builtins.str:
        """
        The name of the Oracle Cloud Infrastructure resource that you want to request.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceProperties")
    def resource_properties(self) -> Mapping[str, builtins.str]:
        """
        A map of various properties associated with the Oracle Cloud Infrastructure resource.
        """
        return pulumi.get(self, "resource_properties")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetCompartmentId")
    def target_compartment_id(self) -> builtins.str:
        """
        The OCID of the tenancy for which you want to request the Oracle Cloud Infrastructure resource for. This is an optional parameter.
        """
        return pulumi.get(self, "target_compartment_id")

    @property
    @pulumi.getter(name="timeNeededBefore")
    def time_needed_before(self) -> builtins.str:
        """
        the date before which you would ideally like the Oracle Cloud Infrastructure resource to be delivered to you.
        """
        return pulumi.get(self, "time_needed_before")


class AwaitableGetOccmDemandSignalItemResult(GetOccmDemandSignalItemResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOccmDemandSignalItemResult(
            availability_domain=self.availability_domain,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            demand_quantity=self.demand_quantity,
            demand_signal_catalog_resource_id=self.demand_signal_catalog_resource_id,
            demand_signal_id=self.demand_signal_id,
            demand_signal_namespace=self.demand_signal_namespace,
            freeform_tags=self.freeform_tags,
            id=self.id,
            notes=self.notes,
            occm_demand_signal_item_id=self.occm_demand_signal_item_id,
            region=self.region,
            request_type=self.request_type,
            resource_name=self.resource_name,
            resource_properties=self.resource_properties,
            state=self.state,
            system_tags=self.system_tags,
            target_compartment_id=self.target_compartment_id,
            time_needed_before=self.time_needed_before)


def get_occm_demand_signal_item(occm_demand_signal_item_id: Optional[builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOccmDemandSignalItemResult:
    """
    This data source provides details about a specific Occm Demand Signal Item resource in Oracle Cloud Infrastructure Capacity Management service.

    This is a GET API to get the details of a demand signal item resource representing the details of the resource demanded by you.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_occm_demand_signal_item = oci.CapacityManagement.get_occm_demand_signal_item(occm_demand_signal_item_id=test_occm_demand_signal_item_oci_capacity_management_occm_demand_signal_item["id"])
    ```


    :param builtins.str occm_demand_signal_item_id: The OCID of the demand signal item.
    """
    __args__ = dict()
    __args__['occmDemandSignalItemId'] = occm_demand_signal_item_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CapacityManagement/getOccmDemandSignalItem:getOccmDemandSignalItem', __args__, opts=opts, typ=GetOccmDemandSignalItemResult).value

    return AwaitableGetOccmDemandSignalItemResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        demand_quantity=pulumi.get(__ret__, 'demand_quantity'),
        demand_signal_catalog_resource_id=pulumi.get(__ret__, 'demand_signal_catalog_resource_id'),
        demand_signal_id=pulumi.get(__ret__, 'demand_signal_id'),
        demand_signal_namespace=pulumi.get(__ret__, 'demand_signal_namespace'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        notes=pulumi.get(__ret__, 'notes'),
        occm_demand_signal_item_id=pulumi.get(__ret__, 'occm_demand_signal_item_id'),
        region=pulumi.get(__ret__, 'region'),
        request_type=pulumi.get(__ret__, 'request_type'),
        resource_name=pulumi.get(__ret__, 'resource_name'),
        resource_properties=pulumi.get(__ret__, 'resource_properties'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        target_compartment_id=pulumi.get(__ret__, 'target_compartment_id'),
        time_needed_before=pulumi.get(__ret__, 'time_needed_before'))
def get_occm_demand_signal_item_output(occm_demand_signal_item_id: Optional[pulumi.Input[builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOccmDemandSignalItemResult]:
    """
    This data source provides details about a specific Occm Demand Signal Item resource in Oracle Cloud Infrastructure Capacity Management service.

    This is a GET API to get the details of a demand signal item resource representing the details of the resource demanded by you.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_occm_demand_signal_item = oci.CapacityManagement.get_occm_demand_signal_item(occm_demand_signal_item_id=test_occm_demand_signal_item_oci_capacity_management_occm_demand_signal_item["id"])
    ```


    :param builtins.str occm_demand_signal_item_id: The OCID of the demand signal item.
    """
    __args__ = dict()
    __args__['occmDemandSignalItemId'] = occm_demand_signal_item_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CapacityManagement/getOccmDemandSignalItem:getOccmDemandSignalItem', __args__, opts=opts, typ=GetOccmDemandSignalItemResult)
    return __ret__.apply(lambda __response__: GetOccmDemandSignalItemResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        demand_quantity=pulumi.get(__response__, 'demand_quantity'),
        demand_signal_catalog_resource_id=pulumi.get(__response__, 'demand_signal_catalog_resource_id'),
        demand_signal_id=pulumi.get(__response__, 'demand_signal_id'),
        demand_signal_namespace=pulumi.get(__response__, 'demand_signal_namespace'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        notes=pulumi.get(__response__, 'notes'),
        occm_demand_signal_item_id=pulumi.get(__response__, 'occm_demand_signal_item_id'),
        region=pulumi.get(__response__, 'region'),
        request_type=pulumi.get(__response__, 'request_type'),
        resource_name=pulumi.get(__response__, 'resource_name'),
        resource_properties=pulumi.get(__response__, 'resource_properties'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        target_compartment_id=pulumi.get(__response__, 'target_compartment_id'),
        time_needed_before=pulumi.get(__response__, 'time_needed_before')))
