# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDataSourceResult',
    'AwaitableGetDataSourceResult',
    'get_data_source',
    'get_data_source_output',
]

@pulumi.output_type
class GetDataSourceResult:
    """
    A collection of values returned by getDataSource.
    """
    def __init__(__self__, compartment_id=None, data_source_details=None, data_source_detector_mapping_infos=None, data_source_feed_provider=None, data_source_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, region_status_details=None, state=None, status=None, system_tags=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if data_source_details and not isinstance(data_source_details, list):
            raise TypeError("Expected argument 'data_source_details' to be a list")
        pulumi.set(__self__, "data_source_details", data_source_details)
        if data_source_detector_mapping_infos and not isinstance(data_source_detector_mapping_infos, list):
            raise TypeError("Expected argument 'data_source_detector_mapping_infos' to be a list")
        pulumi.set(__self__, "data_source_detector_mapping_infos", data_source_detector_mapping_infos)
        if data_source_feed_provider and not isinstance(data_source_feed_provider, str):
            raise TypeError("Expected argument 'data_source_feed_provider' to be a str")
        pulumi.set(__self__, "data_source_feed_provider", data_source_feed_provider)
        if data_source_id and not isinstance(data_source_id, str):
            raise TypeError("Expected argument 'data_source_id' to be a str")
        pulumi.set(__self__, "data_source_id", data_source_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region_status_details and not isinstance(region_status_details, list):
            raise TypeError("Expected argument 'region_status_details' to be a list")
        pulumi.set(__self__, "region_status_details", region_status_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Compartment OCID of data source
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dataSourceDetails")
    def data_source_details(self) -> Sequence['outputs.GetDataSourceDataSourceDetailResult']:
        """
        Details specific to the data source type.
        """
        return pulumi.get(self, "data_source_details")

    @property
    @pulumi.getter(name="dataSourceDetectorMappingInfos")
    def data_source_detector_mapping_infos(self) -> Sequence['outputs.GetDataSourceDataSourceDetectorMappingInfoResult']:
        """
        Information about the detector recipe and rule attached
        """
        return pulumi.get(self, "data_source_detector_mapping_infos")

    @property
    @pulumi.getter(name="dataSourceFeedProvider")
    def data_source_feed_provider(self) -> builtins.str:
        """
        Possible type of dataSourceFeed Provider(LoggingQuery)
        """
        return pulumi.get(self, "data_source_feed_provider")

    @property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> builtins.str:
        return pulumi.get(self, "data_source_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        Display name of the data source
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        OCID for the data source
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="regionStatusDetails")
    def region_status_details(self) -> Sequence['outputs.GetDataSourceRegionStatusDetailResult']:
        """
        Information about the region and status of query replication
        """
        return pulumi.get(self, "region_status_details")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current lifecycle state of the resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Enablement status of the data source
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the Data source was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The date and time the data source was updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetDataSourceResult(GetDataSourceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataSourceResult(
            compartment_id=self.compartment_id,
            data_source_details=self.data_source_details,
            data_source_detector_mapping_infos=self.data_source_detector_mapping_infos,
            data_source_feed_provider=self.data_source_feed_provider,
            data_source_id=self.data_source_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            region_status_details=self.region_status_details,
            state=self.state,
            status=self.status,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_data_source(data_source_id: Optional[builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataSourceResult:
    """
    This data source provides details about a specific Data Source resource in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a data source (DataSource resource) identified by dataSourceId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_source = oci.CloudGuard.get_data_source(data_source_id=test_data_source_oci_cloud_guard_data_source["id"])
    ```


    :param builtins.str data_source_id: Data source OCID.
    """
    __args__ = dict()
    __args__['dataSourceId'] = data_source_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudGuard/getDataSource:getDataSource', __args__, opts=opts, typ=GetDataSourceResult).value

    return AwaitableGetDataSourceResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        data_source_details=pulumi.get(__ret__, 'data_source_details'),
        data_source_detector_mapping_infos=pulumi.get(__ret__, 'data_source_detector_mapping_infos'),
        data_source_feed_provider=pulumi.get(__ret__, 'data_source_feed_provider'),
        data_source_id=pulumi.get(__ret__, 'data_source_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        region_status_details=pulumi.get(__ret__, 'region_status_details'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_data_source_output(data_source_id: Optional[pulumi.Input[builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDataSourceResult]:
    """
    This data source provides details about a specific Data Source resource in Oracle Cloud Infrastructure Cloud Guard service.

    Returns a data source (DataSource resource) identified by dataSourceId.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_source = oci.CloudGuard.get_data_source(data_source_id=test_data_source_oci_cloud_guard_data_source["id"])
    ```


    :param builtins.str data_source_id: Data source OCID.
    """
    __args__ = dict()
    __args__['dataSourceId'] = data_source_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CloudGuard/getDataSource:getDataSource', __args__, opts=opts, typ=GetDataSourceResult)
    return __ret__.apply(lambda __response__: GetDataSourceResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        data_source_details=pulumi.get(__response__, 'data_source_details'),
        data_source_detector_mapping_infos=pulumi.get(__response__, 'data_source_detector_mapping_infos'),
        data_source_feed_provider=pulumi.get(__response__, 'data_source_feed_provider'),
        data_source_id=pulumi.get(__response__, 'data_source_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        region_status_details=pulumi.get(__response__, 'region_status_details'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
