# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCpesResult',
    'AwaitableGetCpesResult',
    'get_cpes',
    'get_cpes_output',
]

@pulumi.output_type
class GetCpesResult:
    """
    A collection of values returned by getCpes.
    """
    def __init__(__self__, compartment_id=None, cpes=None, filters=None, id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if cpes and not isinstance(cpes, list):
            raise TypeError("Expected argument 'cpes' to be a list")
        pulumi.set(__self__, "cpes", cpes)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the CPE.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def cpes(self) -> Sequence['outputs.GetCpesCpeResult']:
        """
        The list of cpes.
        """
        return pulumi.get(self, "cpes")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetCpesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetCpesResult(GetCpesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCpesResult(
            compartment_id=self.compartment_id,
            cpes=self.cpes,
            filters=self.filters,
            id=self.id)


def get_cpes(compartment_id: Optional[builtins.str] = None,
             filters: Optional[Sequence[Union['GetCpesFilterArgs', 'GetCpesFilterArgsDict']]] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCpesResult:
    """
    This data source provides the list of Cpes in Oracle Cloud Infrastructure Core service.

    Lists the customer-premises equipment objects (CPEs) in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cpes = oci.Core.get_cpes(compartment_id=compartment_id)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getCpes:getCpes', __args__, opts=opts, typ=GetCpesResult).value

    return AwaitableGetCpesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        cpes=pulumi.get(__ret__, 'cpes'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_cpes_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                    filters: Optional[pulumi.Input[Optional[Sequence[Union['GetCpesFilterArgs', 'GetCpesFilterArgsDict']]]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCpesResult]:
    """
    This data source provides the list of Cpes in Oracle Cloud Infrastructure Core service.

    Lists the customer-premises equipment objects (CPEs) in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cpes = oci.Core.get_cpes(compartment_id=compartment_id)
    ```


    :param builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getCpes:getCpes', __args__, opts=opts, typ=GetCpesResult)
    return __ret__.apply(lambda __response__: GetCpesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        cpes=pulumi.get(__response__, 'cpes'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
