# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCrossConnectGroupResult',
    'AwaitableGetCrossConnectGroupResult',
    'get_cross_connect_group',
    'get_cross_connect_group_output',
]

@pulumi.output_type
class GetCrossConnectGroupResult:
    """
    A collection of values returned by getCrossConnectGroup.
    """
    def __init__(__self__, compartment_id=None, cross_connect_group_id=None, customer_reference_name=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, macsec_properties=None, oci_logical_device_name=None, oci_physical_device_name=None, state=None, time_created=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if cross_connect_group_id and not isinstance(cross_connect_group_id, str):
            raise TypeError("Expected argument 'cross_connect_group_id' to be a str")
        pulumi.set(__self__, "cross_connect_group_id", cross_connect_group_id)
        if customer_reference_name and not isinstance(customer_reference_name, str):
            raise TypeError("Expected argument 'customer_reference_name' to be a str")
        pulumi.set(__self__, "customer_reference_name", customer_reference_name)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if macsec_properties and not isinstance(macsec_properties, list):
            raise TypeError("Expected argument 'macsec_properties' to be a list")
        pulumi.set(__self__, "macsec_properties", macsec_properties)
        if oci_logical_device_name and not isinstance(oci_logical_device_name, str):
            raise TypeError("Expected argument 'oci_logical_device_name' to be a str")
        pulumi.set(__self__, "oci_logical_device_name", oci_logical_device_name)
        if oci_physical_device_name and not isinstance(oci_physical_device_name, str):
            raise TypeError("Expected argument 'oci_physical_device_name' to be a str")
        pulumi.set(__self__, "oci_physical_device_name", oci_physical_device_name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the cross-connect group.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="crossConnectGroupId")
    def cross_connect_group_id(self) -> builtins.str:
        return pulumi.get(self, "cross_connect_group_id")

    @property
    @pulumi.getter(name="customerReferenceName")
    def customer_reference_name(self) -> builtins.str:
        """
        A reference name or identifier for the physical fiber connection that this cross-connect group uses.
        """
        return pulumi.get(self, "customer_reference_name")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The cross-connect group's Oracle ID (OCID).
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="macsecProperties")
    def macsec_properties(self) -> Sequence['outputs.GetCrossConnectGroupMacsecPropertyResult']:
        """
        Properties used for MACsec (if capable).
        """
        return pulumi.get(self, "macsec_properties")

    @property
    @pulumi.getter(name="ociLogicalDeviceName")
    def oci_logical_device_name(self) -> builtins.str:
        """
        The FastConnect device that terminates the logical connection. This device might be different than the device that terminates the physical connection.
        """
        return pulumi.get(self, "oci_logical_device_name")

    @property
    @pulumi.getter(name="ociPhysicalDeviceName")
    def oci_physical_device_name(self) -> builtins.str:
        """
        The FastConnect device that terminates the physical connection.
        """
        return pulumi.get(self, "oci_physical_device_name")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The cross-connect group's current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the cross-connect group was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


class AwaitableGetCrossConnectGroupResult(GetCrossConnectGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCrossConnectGroupResult(
            compartment_id=self.compartment_id,
            cross_connect_group_id=self.cross_connect_group_id,
            customer_reference_name=self.customer_reference_name,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            macsec_properties=self.macsec_properties,
            oci_logical_device_name=self.oci_logical_device_name,
            oci_physical_device_name=self.oci_physical_device_name,
            state=self.state,
            time_created=self.time_created)


def get_cross_connect_group(cross_connect_group_id: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCrossConnectGroupResult:
    """
    This data source provides details about a specific Cross Connect Group resource in Oracle Cloud Infrastructure Core service.

    Gets the specified cross-connect group's information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cross_connect_group = oci.Core.get_cross_connect_group(cross_connect_group_id=test_cross_connect_group_oci_core_cross_connect_group["id"])
    ```


    :param builtins.str cross_connect_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cross-connect group.
    """
    __args__ = dict()
    __args__['crossConnectGroupId'] = cross_connect_group_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getCrossConnectGroup:getCrossConnectGroup', __args__, opts=opts, typ=GetCrossConnectGroupResult).value

    return AwaitableGetCrossConnectGroupResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        cross_connect_group_id=pulumi.get(__ret__, 'cross_connect_group_id'),
        customer_reference_name=pulumi.get(__ret__, 'customer_reference_name'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        macsec_properties=pulumi.get(__ret__, 'macsec_properties'),
        oci_logical_device_name=pulumi.get(__ret__, 'oci_logical_device_name'),
        oci_physical_device_name=pulumi.get(__ret__, 'oci_physical_device_name'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'))
def get_cross_connect_group_output(cross_connect_group_id: Optional[pulumi.Input[builtins.str]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCrossConnectGroupResult]:
    """
    This data source provides details about a specific Cross Connect Group resource in Oracle Cloud Infrastructure Core service.

    Gets the specified cross-connect group's information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cross_connect_group = oci.Core.get_cross_connect_group(cross_connect_group_id=test_cross_connect_group_oci_core_cross_connect_group["id"])
    ```


    :param builtins.str cross_connect_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cross-connect group.
    """
    __args__ = dict()
    __args__['crossConnectGroupId'] = cross_connect_group_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getCrossConnectGroup:getCrossConnectGroup', __args__, opts=opts, typ=GetCrossConnectGroupResult)
    return __ret__.apply(lambda __response__: GetCrossConnectGroupResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        cross_connect_group_id=pulumi.get(__response__, 'cross_connect_group_id'),
        customer_reference_name=pulumi.get(__response__, 'customer_reference_name'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        macsec_properties=pulumi.get(__response__, 'macsec_properties'),
        oci_logical_device_name=pulumi.get(__response__, 'oci_logical_device_name'),
        oci_physical_device_name=pulumi.get(__response__, 'oci_physical_device_name'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created')))
