# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDatabaseSoftwareImageResult',
    'AwaitableGetDatabaseSoftwareImageResult',
    'get_database_software_image',
    'get_database_software_image_output',
]

@pulumi.output_type
class GetDatabaseSoftwareImageResult:
    """
    A collection of values returned by getDatabaseSoftwareImage.
    """
    def __init__(__self__, compartment_id=None, database_software_image_id=None, database_software_image_included_patches=None, database_software_image_one_off_patches=None, database_version=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, image_shape_family=None, image_type=None, included_patches_summary=None, is_upgrade_supported=None, lifecycle_details=None, ls_inventory=None, patch_set=None, source_db_home_id=None, state=None, system_tags=None, time_created=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if database_software_image_id and not isinstance(database_software_image_id, str):
            raise TypeError("Expected argument 'database_software_image_id' to be a str")
        pulumi.set(__self__, "database_software_image_id", database_software_image_id)
        if database_software_image_included_patches and not isinstance(database_software_image_included_patches, list):
            raise TypeError("Expected argument 'database_software_image_included_patches' to be a list")
        pulumi.set(__self__, "database_software_image_included_patches", database_software_image_included_patches)
        if database_software_image_one_off_patches and not isinstance(database_software_image_one_off_patches, list):
            raise TypeError("Expected argument 'database_software_image_one_off_patches' to be a list")
        pulumi.set(__self__, "database_software_image_one_off_patches", database_software_image_one_off_patches)
        if database_version and not isinstance(database_version, str):
            raise TypeError("Expected argument 'database_version' to be a str")
        pulumi.set(__self__, "database_version", database_version)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_shape_family and not isinstance(image_shape_family, str):
            raise TypeError("Expected argument 'image_shape_family' to be a str")
        pulumi.set(__self__, "image_shape_family", image_shape_family)
        if image_type and not isinstance(image_type, str):
            raise TypeError("Expected argument 'image_type' to be a str")
        pulumi.set(__self__, "image_type", image_type)
        if included_patches_summary and not isinstance(included_patches_summary, str):
            raise TypeError("Expected argument 'included_patches_summary' to be a str")
        pulumi.set(__self__, "included_patches_summary", included_patches_summary)
        if is_upgrade_supported and not isinstance(is_upgrade_supported, bool):
            raise TypeError("Expected argument 'is_upgrade_supported' to be a bool")
        pulumi.set(__self__, "is_upgrade_supported", is_upgrade_supported)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if ls_inventory and not isinstance(ls_inventory, str):
            raise TypeError("Expected argument 'ls_inventory' to be a str")
        pulumi.set(__self__, "ls_inventory", ls_inventory)
        if patch_set and not isinstance(patch_set, str):
            raise TypeError("Expected argument 'patch_set' to be a str")
        pulumi.set(__self__, "patch_set", patch_set)
        if source_db_home_id and not isinstance(source_db_home_id, str):
            raise TypeError("Expected argument 'source_db_home_id' to be a str")
        pulumi.set(__self__, "source_db_home_id", source_db_home_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="databaseSoftwareImageId")
    def database_software_image_id(self) -> builtins.str:
        return pulumi.get(self, "database_software_image_id")

    @property
    @pulumi.getter(name="databaseSoftwareImageIncludedPatches")
    def database_software_image_included_patches(self) -> Sequence[builtins.str]:
        """
        List of one-off patches for Database Homes.
        """
        return pulumi.get(self, "database_software_image_included_patches")

    @property
    @pulumi.getter(name="databaseSoftwareImageOneOffPatches")
    def database_software_image_one_off_patches(self) -> Sequence[builtins.str]:
        """
        List of one-off patches for Database Homes.
        """
        return pulumi.get(self, "database_software_image_one_off_patches")

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> builtins.str:
        """
        The database version with which the database software image is to be built.
        """
        return pulumi.get(self, "database_version")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The user-friendly name for the database software image. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database software image.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageShapeFamily")
    def image_shape_family(self) -> builtins.str:
        """
        To what shape the image is meant for.
        """
        return pulumi.get(self, "image_shape_family")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> builtins.str:
        """
        The type of software image. Can be grid or database.
        """
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter(name="includedPatchesSummary")
    def included_patches_summary(self) -> builtins.str:
        """
        The patches included in the image and the version of the image.
        """
        return pulumi.get(self, "included_patches_summary")

    @property
    @pulumi.getter(name="isUpgradeSupported")
    def is_upgrade_supported(self) -> builtins.bool:
        """
        True if this Database software image is supported for Upgrade.
        """
        return pulumi.get(self, "is_upgrade_supported")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        Detailed message for the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="lsInventory")
    def ls_inventory(self) -> builtins.str:
        """
        The output from the OPatch lsInventory command, which is passed as a string.
        """
        return pulumi.get(self, "ls_inventory")

    @property
    @pulumi.getter(name="patchSet")
    def patch_set(self) -> builtins.str:
        """
        The PSU or PBP or Release Updates. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        """
        return pulumi.get(self, "patch_set")

    @property
    @pulumi.getter(name="sourceDbHomeId")
    def source_db_home_id(self) -> builtins.str:
        return pulumi.get(self, "source_db_home_id")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the database software image.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The date and time the database software image was created.
        """
        return pulumi.get(self, "time_created")


class AwaitableGetDatabaseSoftwareImageResult(GetDatabaseSoftwareImageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseSoftwareImageResult(
            compartment_id=self.compartment_id,
            database_software_image_id=self.database_software_image_id,
            database_software_image_included_patches=self.database_software_image_included_patches,
            database_software_image_one_off_patches=self.database_software_image_one_off_patches,
            database_version=self.database_version,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            image_shape_family=self.image_shape_family,
            image_type=self.image_type,
            included_patches_summary=self.included_patches_summary,
            is_upgrade_supported=self.is_upgrade_supported,
            lifecycle_details=self.lifecycle_details,
            ls_inventory=self.ls_inventory,
            patch_set=self.patch_set,
            source_db_home_id=self.source_db_home_id,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created)


def get_database_software_image(database_software_image_id: Optional[builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseSoftwareImageResult:
    """
    This data source provides details about a specific Database Software Image resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified database software image.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_software_image = oci.Database.get_database_software_image(database_software_image_id=test_database_software_image_oci_database_database_software_image["id"])
    ```


    :param builtins.str database_software_image_id: The DB system [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['databaseSoftwareImageId'] = database_software_image_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDatabaseSoftwareImage:getDatabaseSoftwareImage', __args__, opts=opts, typ=GetDatabaseSoftwareImageResult).value

    return AwaitableGetDatabaseSoftwareImageResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        database_software_image_id=pulumi.get(__ret__, 'database_software_image_id'),
        database_software_image_included_patches=pulumi.get(__ret__, 'database_software_image_included_patches'),
        database_software_image_one_off_patches=pulumi.get(__ret__, 'database_software_image_one_off_patches'),
        database_version=pulumi.get(__ret__, 'database_version'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        image_shape_family=pulumi.get(__ret__, 'image_shape_family'),
        image_type=pulumi.get(__ret__, 'image_type'),
        included_patches_summary=pulumi.get(__ret__, 'included_patches_summary'),
        is_upgrade_supported=pulumi.get(__ret__, 'is_upgrade_supported'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        ls_inventory=pulumi.get(__ret__, 'ls_inventory'),
        patch_set=pulumi.get(__ret__, 'patch_set'),
        source_db_home_id=pulumi.get(__ret__, 'source_db_home_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'))
def get_database_software_image_output(database_software_image_id: Optional[pulumi.Input[builtins.str]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDatabaseSoftwareImageResult]:
    """
    This data source provides details about a specific Database Software Image resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified database software image.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database_software_image = oci.Database.get_database_software_image(database_software_image_id=test_database_software_image_oci_database_database_software_image["id"])
    ```


    :param builtins.str database_software_image_id: The DB system [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['databaseSoftwareImageId'] = database_software_image_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Database/getDatabaseSoftwareImage:getDatabaseSoftwareImage', __args__, opts=opts, typ=GetDatabaseSoftwareImageResult)
    return __ret__.apply(lambda __response__: GetDatabaseSoftwareImageResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        database_software_image_id=pulumi.get(__response__, 'database_software_image_id'),
        database_software_image_included_patches=pulumi.get(__response__, 'database_software_image_included_patches'),
        database_software_image_one_off_patches=pulumi.get(__response__, 'database_software_image_one_off_patches'),
        database_version=pulumi.get(__response__, 'database_version'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        image_shape_family=pulumi.get(__response__, 'image_shape_family'),
        image_type=pulumi.get(__response__, 'image_type'),
        included_patches_summary=pulumi.get(__response__, 'included_patches_summary'),
        is_upgrade_supported=pulumi.get(__response__, 'is_upgrade_supported'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        ls_inventory=pulumi.get(__response__, 'ls_inventory'),
        patch_set=pulumi.get(__response__, 'patch_set'),
        source_db_home_id=pulumi.get(__response__, 'source_db_home_id'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created')))
