# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAlertResult',
    'AwaitableGetAlertResult',
    'get_alert',
    'get_alert_output',
]

@pulumi.output_type
class GetAlertResult:
    """
    A collection of values returned by getAlert.
    """
    def __init__(__self__, alert_id=None, alert_policy_rule_key=None, alert_policy_rule_name=None, alert_type=None, comment=None, compartment_id=None, defined_tags=None, description=None, display_name=None, feature_details=None, freeform_tags=None, id=None, operation=None, operation_status=None, operation_time=None, policy_id=None, resource_name=None, severity=None, state=None, status=None, system_tags=None, target_ids=None, target_names=None, time_created=None, time_updated=None):
        if alert_id and not isinstance(alert_id, str):
            raise TypeError("Expected argument 'alert_id' to be a str")
        pulumi.set(__self__, "alert_id", alert_id)
        if alert_policy_rule_key and not isinstance(alert_policy_rule_key, str):
            raise TypeError("Expected argument 'alert_policy_rule_key' to be a str")
        pulumi.set(__self__, "alert_policy_rule_key", alert_policy_rule_key)
        if alert_policy_rule_name and not isinstance(alert_policy_rule_name, str):
            raise TypeError("Expected argument 'alert_policy_rule_name' to be a str")
        pulumi.set(__self__, "alert_policy_rule_name", alert_policy_rule_name)
        if alert_type and not isinstance(alert_type, str):
            raise TypeError("Expected argument 'alert_type' to be a str")
        pulumi.set(__self__, "alert_type", alert_type)
        if comment and not isinstance(comment, str):
            raise TypeError("Expected argument 'comment' to be a str")
        pulumi.set(__self__, "comment", comment)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if feature_details and not isinstance(feature_details, dict):
            raise TypeError("Expected argument 'feature_details' to be a dict")
        pulumi.set(__self__, "feature_details", feature_details)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if operation and not isinstance(operation, str):
            raise TypeError("Expected argument 'operation' to be a str")
        pulumi.set(__self__, "operation", operation)
        if operation_status and not isinstance(operation_status, str):
            raise TypeError("Expected argument 'operation_status' to be a str")
        pulumi.set(__self__, "operation_status", operation_status)
        if operation_time and not isinstance(operation_time, str):
            raise TypeError("Expected argument 'operation_time' to be a str")
        pulumi.set(__self__, "operation_time", operation_time)
        if policy_id and not isinstance(policy_id, str):
            raise TypeError("Expected argument 'policy_id' to be a str")
        pulumi.set(__self__, "policy_id", policy_id)
        if resource_name and not isinstance(resource_name, str):
            raise TypeError("Expected argument 'resource_name' to be a str")
        pulumi.set(__self__, "resource_name", resource_name)
        if severity and not isinstance(severity, str):
            raise TypeError("Expected argument 'severity' to be a str")
        pulumi.set(__self__, "severity", severity)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if target_ids and not isinstance(target_ids, list):
            raise TypeError("Expected argument 'target_ids' to be a list")
        pulumi.set(__self__, "target_ids", target_ids)
        if target_names and not isinstance(target_names, list):
            raise TypeError("Expected argument 'target_names' to be a list")
        pulumi.set(__self__, "target_names", target_names)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="alertId")
    def alert_id(self) -> builtins.str:
        return pulumi.get(self, "alert_id")

    @property
    @pulumi.getter(name="alertPolicyRuleKey")
    def alert_policy_rule_key(self) -> builtins.str:
        """
        The key of the rule of alert policy that triggered alert.
        """
        return pulumi.get(self, "alert_policy_rule_key")

    @property
    @pulumi.getter(name="alertPolicyRuleName")
    def alert_policy_rule_name(self) -> builtins.str:
        """
        The display name of the rule of alert policy that triggered alert.
        """
        return pulumi.get(self, "alert_policy_rule_name")

    @property
    @pulumi.getter(name="alertType")
    def alert_type(self) -> builtins.str:
        """
        Type of the alert. Indicates the Data Safe feature triggering the alert.
        """
        return pulumi.get(self, "alert_type")

    @property
    @pulumi.getter
    def comment(self) -> builtins.str:
        """
        A comment for the alert. Entered by the user.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment that contains the alert.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm) Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the alert.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        The display name of the alert.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="featureDetails")
    def feature_details(self) -> Mapping[str, builtins.str]:
        """
        Map that contains maps of values. Example: `{"Operations": {"CostCenter": "42"}}`
        """
        return pulumi.get(self, "feature_details")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The OCID of the alert.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def operation(self) -> builtins.str:
        """
        The operation (event) that triggered alert.
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter(name="operationStatus")
    def operation_status(self) -> builtins.str:
        """
        The result of the operation (event) that triggered alert.
        """
        return pulumi.get(self, "operation_status")

    @property
    @pulumi.getter(name="operationTime")
    def operation_time(self) -> builtins.str:
        """
        Creation date and time of the operation that triggered alert, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "operation_time")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> builtins.str:
        """
        The OCID of the policy that triggered alert.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> builtins.str:
        """
        The resource endpoint that triggered the alert.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter
    def severity(self) -> builtins.str:
        """
        Severity level of the alert.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the alert.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        The status of the alert.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetIds")
    def target_ids(self) -> Sequence[builtins.str]:
        """
        Array of OCIDs of the target database which are associated with the alert.
        """
        return pulumi.get(self, "target_ids")

    @property
    @pulumi.getter(name="targetNames")
    def target_names(self) -> Sequence[builtins.str]:
        """
        Array of names of the target database.
        """
        return pulumi.get(self, "target_names")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        Creation date and time of the alert, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        Last date and time the alert was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetAlertResult(GetAlertResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlertResult(
            alert_id=self.alert_id,
            alert_policy_rule_key=self.alert_policy_rule_key,
            alert_policy_rule_name=self.alert_policy_rule_name,
            alert_type=self.alert_type,
            comment=self.comment,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            feature_details=self.feature_details,
            freeform_tags=self.freeform_tags,
            id=self.id,
            operation=self.operation,
            operation_status=self.operation_status,
            operation_time=self.operation_time,
            policy_id=self.policy_id,
            resource_name=self.resource_name,
            severity=self.severity,
            state=self.state,
            status=self.status,
            system_tags=self.system_tags,
            target_ids=self.target_ids,
            target_names=self.target_names,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_alert(alert_id: Optional[builtins.str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlertResult:
    """
    This data source provides details about a specific Alert resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified alerts.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_alert = oci.DataSafe.get_alert(alert_id=test_alert_oci_data_safe_alert["id"])
    ```


    :param builtins.str alert_id: The OCID of alert.
    """
    __args__ = dict()
    __args__['alertId'] = alert_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getAlert:getAlert', __args__, opts=opts, typ=GetAlertResult).value

    return AwaitableGetAlertResult(
        alert_id=pulumi.get(__ret__, 'alert_id'),
        alert_policy_rule_key=pulumi.get(__ret__, 'alert_policy_rule_key'),
        alert_policy_rule_name=pulumi.get(__ret__, 'alert_policy_rule_name'),
        alert_type=pulumi.get(__ret__, 'alert_type'),
        comment=pulumi.get(__ret__, 'comment'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        feature_details=pulumi.get(__ret__, 'feature_details'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        operation=pulumi.get(__ret__, 'operation'),
        operation_status=pulumi.get(__ret__, 'operation_status'),
        operation_time=pulumi.get(__ret__, 'operation_time'),
        policy_id=pulumi.get(__ret__, 'policy_id'),
        resource_name=pulumi.get(__ret__, 'resource_name'),
        severity=pulumi.get(__ret__, 'severity'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        target_ids=pulumi.get(__ret__, 'target_ids'),
        target_names=pulumi.get(__ret__, 'target_names'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_alert_output(alert_id: Optional[pulumi.Input[builtins.str]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAlertResult]:
    """
    This data source provides details about a specific Alert resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified alerts.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_alert = oci.DataSafe.get_alert(alert_id=test_alert_oci_data_safe_alert["id"])
    ```


    :param builtins.str alert_id: The OCID of alert.
    """
    __args__ = dict()
    __args__['alertId'] = alert_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getAlert:getAlert', __args__, opts=opts, typ=GetAlertResult)
    return __ret__.apply(lambda __response__: GetAlertResult(
        alert_id=pulumi.get(__response__, 'alert_id'),
        alert_policy_rule_key=pulumi.get(__response__, 'alert_policy_rule_key'),
        alert_policy_rule_name=pulumi.get(__response__, 'alert_policy_rule_name'),
        alert_type=pulumi.get(__response__, 'alert_type'),
        comment=pulumi.get(__response__, 'comment'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        feature_details=pulumi.get(__response__, 'feature_details'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        operation=pulumi.get(__response__, 'operation'),
        operation_status=pulumi.get(__response__, 'operation_status'),
        operation_time=pulumi.get(__response__, 'operation_time'),
        policy_id=pulumi.get(__response__, 'policy_id'),
        resource_name=pulumi.get(__response__, 'resource_name'),
        severity=pulumi.get(__response__, 'severity'),
        state=pulumi.get(__response__, 'state'),
        status=pulumi.get(__response__, 'status'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        target_ids=pulumi.get(__response__, 'target_ids'),
        target_names=pulumi.get(__response__, 'target_names'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
